/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appplatform.models.AcceleratorGitRepository;
import com.azure.resourcemanager.appplatform.models.CustomizedAcceleratorProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class CustomizedAcceleratorProperties {
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private CustomizedAcceleratorProvisioningState provisioningState;
    @JsonProperty(value="displayName")
    private String displayName;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="iconUrl")
    private String iconUrl;
    @JsonProperty(value="acceleratorTags")
    private List<String> acceleratorTags;
    @JsonProperty(value="gitRepository", required=true)
    private AcceleratorGitRepository gitRepository;
    private static final ClientLogger LOGGER = new ClientLogger(CustomizedAcceleratorProperties.class);

    public CustomizedAcceleratorProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String displayName() {
        return this.displayName;
    }

    public CustomizedAcceleratorProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String description() {
        return this.description;
    }

    public CustomizedAcceleratorProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public String iconUrl() {
        return this.iconUrl;
    }

    public CustomizedAcceleratorProperties withIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
        return this;
    }

    public List<String> acceleratorTags() {
        return this.acceleratorTags;
    }

    public CustomizedAcceleratorProperties withAcceleratorTags(List<String> acceleratorTags) {
        this.acceleratorTags = acceleratorTags;
        return this;
    }

    public AcceleratorGitRepository gitRepository() {
        return this.gitRepository;
    }

    public CustomizedAcceleratorProperties withGitRepository(AcceleratorGitRepository gitRepository) {
        this.gitRepository = gitRepository;
        return this;
    }

    public void validate() {
        if (this.gitRepository() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property gitRepository in model CustomizedAcceleratorProperties"));
        }
        this.gitRepository().validate();
    }
}

