/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.implementation;

import com.azure.core.management.Resource;
import com.azure.core.util.CoreUtils;
import com.azure.resourcemanager.appplatform.AppPlatformManager;
import com.azure.resourcemanager.appplatform.fluent.AppPlatformManagementClient;
import com.azure.resourcemanager.appplatform.fluent.models.BuildServiceAgentPoolResourceInner;
import com.azure.resourcemanager.appplatform.fluent.models.BuildServiceInner;
import com.azure.resourcemanager.appplatform.fluent.models.ConfigServerResourceInner;
import com.azure.resourcemanager.appplatform.fluent.models.ConfigurationServiceResourceInner;
import com.azure.resourcemanager.appplatform.fluent.models.MonitoringSettingResourceInner;
import com.azure.resourcemanager.appplatform.fluent.models.ServiceRegistryResourceInner;
import com.azure.resourcemanager.appplatform.fluent.models.ServiceResourceInner;
import com.azure.resourcemanager.appplatform.implementation.SpringAppsImpl;
import com.azure.resourcemanager.appplatform.implementation.SpringConfigurationServiceImpl;
import com.azure.resourcemanager.appplatform.implementation.SpringConfigurationServicesImpl;
import com.azure.resourcemanager.appplatform.implementation.SpringServiceCertificatesImpl;
import com.azure.resourcemanager.appplatform.implementation.SpringServiceRegistriesImpl;
import com.azure.resourcemanager.appplatform.implementation.SpringServiceRegistryImpl;
import com.azure.resourcemanager.appplatform.models.BuildServiceAgentPoolProperties;
import com.azure.resourcemanager.appplatform.models.BuildServiceAgentPoolSizeProperties;
import com.azure.resourcemanager.appplatform.models.BuildServiceProperties;
import com.azure.resourcemanager.appplatform.models.ConfigServerGitProperty;
import com.azure.resourcemanager.appplatform.models.ConfigServerProperties;
import com.azure.resourcemanager.appplatform.models.ConfigServerSettings;
import com.azure.resourcemanager.appplatform.models.ConfigurationServiceGitProperty;
import com.azure.resourcemanager.appplatform.models.ConfigurationServiceGitRepository;
import com.azure.resourcemanager.appplatform.models.KeyVaultCertificateProperties;
import com.azure.resourcemanager.appplatform.models.MonitoringSettingProperties;
import com.azure.resourcemanager.appplatform.models.RegenerateTestKeyRequestPayload;
import com.azure.resourcemanager.appplatform.models.Sku;
import com.azure.resourcemanager.appplatform.models.SkuName;
import com.azure.resourcemanager.appplatform.models.SpringApps;
import com.azure.resourcemanager.appplatform.models.SpringConfigurationService;
import com.azure.resourcemanager.appplatform.models.SpringService;
import com.azure.resourcemanager.appplatform.models.SpringServiceCertificates;
import com.azure.resourcemanager.appplatform.models.SpringServiceRegistry;
import com.azure.resourcemanager.appplatform.models.TestKeyType;
import com.azure.resourcemanager.appplatform.models.TestKeys;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.dag.FunctionalTaskItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import reactor.core.publisher.Mono;

public class SpringServiceImpl
extends GroupableResourceImpl<SpringService, ServiceResourceInner, SpringServiceImpl, AppPlatformManager>
implements SpringService,
SpringService.Definition,
SpringService.Update {
    private final SpringServiceCertificatesImpl certificates = new SpringServiceCertificatesImpl(this);
    private final SpringAppsImpl apps = new SpringAppsImpl(this);
    private final SpringConfigurationServicesImpl configurationServices = new SpringConfigurationServicesImpl(this);
    private final SpringServiceRegistriesImpl serviceRegistries = new SpringServiceRegistriesImpl(this);
    private FunctionalTaskItem configServerTask = null;
    private FunctionalTaskItem monitoringSettingTask = null;
    private ServiceResourceInner patchToUpdate = new ServiceResourceInner();
    private boolean updated;
    private final ConfigurationServiceConfig configurationServiceConfig = new ConfigurationServiceConfig();

    SpringServiceImpl(String name, ServiceResourceInner innerObject, AppPlatformManager manager) {
        super(name, (Resource)innerObject, (Manager)manager);
    }

    public SpringServiceImpl update() {
        return (SpringServiceImpl)super.update();
    }

    @Override
    public Sku sku() {
        return ((ServiceResourceInner)((Object)this.innerModel())).sku();
    }

    @Override
    public SpringApps apps() {
        return this.apps;
    }

    @Override
    public SpringServiceCertificates certificates() {
        return this.certificates;
    }

    @Override
    public MonitoringSettingProperties getMonitoringSetting() {
        return (MonitoringSettingProperties)this.getMonitoringSettingAsync().block();
    }

    @Override
    public Mono<MonitoringSettingProperties> getMonitoringSettingAsync() {
        return ((AppPlatformManagementClient)((AppPlatformManager)this.manager()).serviceClient()).getMonitoringSettings().getAsync(this.resourceGroupName(), this.name()).map(MonitoringSettingResourceInner::properties);
    }

    @Override
    public ConfigServerProperties getServerProperties() {
        return (ConfigServerProperties)this.getServerPropertiesAsync().block();
    }

    @Override
    public Mono<ConfigServerProperties> getServerPropertiesAsync() {
        return ((AppPlatformManagementClient)((AppPlatformManager)this.manager()).serviceClient()).getConfigServers().getAsync(this.resourceGroupName(), this.name()).map(ConfigServerResourceInner::properties);
    }

    @Override
    public TestKeys listTestKeys() {
        return (TestKeys)this.listTestKeysAsync().block();
    }

    @Override
    public Mono<TestKeys> listTestKeysAsync() {
        return ((AppPlatformManagementClient)((AppPlatformManager)this.manager()).serviceClient()).getServices().listTestKeysAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public TestKeys regenerateTestKeys(TestKeyType keyType) {
        return (TestKeys)this.regenerateTestKeysAsync(keyType).block();
    }

    @Override
    public Mono<TestKeys> regenerateTestKeysAsync(TestKeyType keyType) {
        return ((AppPlatformManagementClient)((AppPlatformManager)this.manager()).serviceClient()).getServices().regenerateTestKeyAsync(this.resourceGroupName(), this.name(), new RegenerateTestKeyRequestPayload().withKeyType(keyType));
    }

    @Override
    public void disableTestEndpoint() {
        this.disableTestEndpointAsync().block();
    }

    @Override
    public Mono<Void> disableTestEndpointAsync() {
        return ((AppPlatformManagementClient)((AppPlatformManager)this.manager()).serviceClient()).getServices().disableTestEndpointAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public TestKeys enableTestEndpoint() {
        return (TestKeys)this.enableTestEndpointAsync().block();
    }

    @Override
    public Mono<TestKeys> enableTestEndpointAsync() {
        return ((AppPlatformManagementClient)((AppPlatformManager)this.manager()).serviceClient()).getServices().enableTestEndpointAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public SpringConfigurationService getDefaultConfigurationService() {
        return ((AppPlatformManagementClient)((AppPlatformManager)this.manager()).serviceClient()).getConfigurationServices().list(this.resourceGroupName(), this.name()).stream().filter(inner -> Objects.equals(inner.name(), "default")).map(inner -> new SpringConfigurationServiceImpl(inner.name(), this, (ConfigurationServiceResourceInner)((Object)inner))).findFirst().orElse(null);
    }

    @Override
    public SpringServiceRegistry getDefaultServiceRegistry() {
        return ((AppPlatformManagementClient)((AppPlatformManager)this.manager()).serviceClient()).getServiceRegistries().list(this.resourceGroupName(), this.name()).stream().filter(inner -> Objects.equals(inner.name(), "default")).map(inner -> new SpringServiceRegistryImpl(inner.name(), this, (ServiceRegistryResourceInner)((Object)inner))).findFirst().orElse(null);
    }

    @Override
    public SpringServiceImpl withSku(String skuName) {
        return this.withSku(new Sku().withName(skuName));
    }

    @Override
    public SpringServiceImpl withSku(SkuName skuName) {
        return this.withSku(skuName.toString());
    }

    @Override
    public SpringServiceImpl withSku(String skuName, int capacity) {
        return this.withSku(new Sku().withName(skuName).withCapacity(capacity));
    }

    @Override
    public SpringServiceImpl withSku(Sku sku) {
        ((ServiceResourceInner)((Object)this.innerModel())).withSku(sku);
        if (this.isInUpdateMode()) {
            this.patchToUpdate.withSku(sku);
            this.updated = true;
        }
        return this;
    }

    @Override
    public SpringServiceImpl withEnterpriseTierSku() {
        this.withSku(SkuName.E0);
        return this;
    }

    @Override
    public SpringServiceImpl withTracing(String appInsightInstrumentationKey) {
        this.monitoringSettingTask = context -> ((AppPlatformManagementClient)((AppPlatformManager)this.manager()).serviceClient()).getMonitoringSettings().updatePatchAsync(this.resourceGroupName(), this.name(), new MonitoringSettingResourceInner().withProperties(new MonitoringSettingProperties().withAppInsightsInstrumentationKey(appInsightInstrumentationKey).withTraceEnabled(true))).then(context.voidMono());
        return this;
    }

    @Override
    public SpringServiceImpl withoutTracing() {
        this.monitoringSettingTask = context -> ((AppPlatformManagementClient)((AppPlatformManager)this.manager()).serviceClient()).getMonitoringSettings().updatePatchAsync(this.resourceGroupName(), this.name(), new MonitoringSettingResourceInner().withProperties(new MonitoringSettingProperties().withTraceEnabled(false))).then(context.voidMono());
        return this;
    }

    @Override
    public SpringServiceImpl withGitUri(String uri) {
        this.configServerTask = context -> ((AppPlatformManagementClient)((AppPlatformManager)this.manager()).serviceClient()).getConfigServers().updatePatchAsync(this.resourceGroupName(), this.name(), new ConfigServerResourceInner().withProperties(new ConfigServerProperties().withConfigServer(new ConfigServerSettings().withGitProperty(new ConfigServerGitProperty().withUri(uri))))).then(context.voidMono());
        return this;
    }

    @Override
    public SpringServiceImpl withGitUriAndCredential(String uri, String username, String password) {
        this.configServerTask = context -> ((AppPlatformManagementClient)((AppPlatformManager)this.manager()).serviceClient()).getConfigServers().updatePatchAsync(this.resourceGroupName(), this.name(), new ConfigServerResourceInner().withProperties(new ConfigServerProperties().withConfigServer(new ConfigServerSettings().withGitProperty(new ConfigServerGitProperty().withUri(uri).withUsername(username).withPassword(password))))).then(context.voidMono());
        return this;
    }

    @Override
    public SpringServiceImpl withGitConfig(ConfigServerGitProperty gitConfig) {
        this.configServerTask = context -> ((AppPlatformManagementClient)((AppPlatformManager)this.manager()).serviceClient()).getConfigServers().updatePatchAsync(this.resourceGroupName(), this.name(), new ConfigServerResourceInner().withProperties(new ConfigServerProperties().withConfigServer(new ConfigServerSettings().withGitProperty(gitConfig)))).then(context.voidMono());
        return this;
    }

    @Override
    public SpringServiceImpl withoutGitConfig() {
        return this.withGitConfig(null);
    }

    public void beforeGroupCreateOrUpdate() {
        if (this.configServerTask != null) {
            this.addPostRunDependent(this.configServerTask);
        }
        if (this.monitoringSettingTask != null) {
            this.addPostRunDependent(this.monitoringSettingTask);
        }
        if (this.isEnterpriseTier()) {
            if (this.configurationServiceConfig.needCreateOrUpdate()) {
                this.prepareCreateOrUpdateConfigurationService();
                this.configurationServiceConfig.clearUpdate();
            }
            if (this.isInCreateMode()) {
                this.prepareCreateServiceRegistry();
            }
        }
        this.configServerTask = null;
        this.monitoringSettingTask = null;
    }

    public Mono<SpringService> createResourceAsync() {
        Mono createOrUpdate;
        if (this.isInCreateMode()) {
            createOrUpdate = ((AppPlatformManagementClient)((AppPlatformManager)this.manager()).serviceClient()).getServices().createOrUpdateAsync(this.resourceGroupName(), this.name(), (ServiceResourceInner)((Object)this.innerModel()));
            if (this.isEnterpriseTier()) {
                createOrUpdate = createOrUpdate.flatMap(inner -> this.createDefaultBuildServiceAsync().then(this.initializeDefaultBuildServiceAgentPoolAsync()).then(Mono.just((Object)inner)));
            }
        } else if (this.updated) {
            createOrUpdate = ((AppPlatformManagementClient)((AppPlatformManager)this.manager()).serviceClient()).getServices().updateAsync(this.resourceGroupName(), this.name(), this.patchToUpdate);
            this.patchToUpdate = new ServiceResourceInner();
            this.updated = false;
        } else {
            return Mono.just((Object)this);
        }
        return createOrUpdate.map(inner -> {
            this.setInner(inner);
            return this;
        });
    }

    public Mono<Void> afterPostRunAsync(boolean isGroupFaulted) {
        return Mono.just((Object)true).map(ignored -> {
            this.clearCache();
            return ignored;
        }).then();
    }

    protected Mono<ServiceResourceInner> getInnerAsync() {
        return ((AppPlatformManagementClient)((AppPlatformManager)this.manager()).serviceClient()).getServices().getByResourceGroupAsync(this.resourceGroupName(), this.name()).map(inner -> {
            this.clearCache();
            return inner;
        });
    }

    @Override
    public SpringServiceImpl withCertificate(String name, String keyVaultUri, String certNameInKeyVault) {
        this.certificates.prepareCreateOrUpdate(name, new KeyVaultCertificateProperties().withVaultUri(keyVaultUri).withKeyVaultCertName(certNameInKeyVault));
        return this;
    }

    @Override
    public SpringServiceImpl withCertificate(String name, String keyVaultUri, String certNameInKeyVault, String certVersion) {
        this.certificates.prepareCreateOrUpdate(name, new KeyVaultCertificateProperties().withVaultUri(keyVaultUri).withKeyVaultCertName(certNameInKeyVault).withCertVersion(certVersion));
        return this;
    }

    @Override
    public SpringServiceImpl withoutCertificate(String name) {
        this.certificates.prepareDelete(name);
        return this;
    }

    @Override
    public SpringServiceImpl withDefaultGitRepository(String uri, String branch, List<String> filePatterns) {
        return this.withGitRepository("default", uri, branch, (List)filePatterns);
    }

    @Override
    public SpringServiceImpl withGitRepository(String name, String uri, String branch, List<String> filePatterns) {
        if (CoreUtils.isNullOrEmpty((CharSequence)name)) {
            return this;
        }
        this.configurationServiceConfig.addRepository(new ConfigurationServiceGitRepository().withName(name).withUri(uri).withPatterns(filePatterns).withLabel(branch));
        return this;
    }

    @Override
    public SpringServiceImpl withGitRepositoryConfig(ConfigurationServiceGitProperty gitConfig) {
        this.configurationServiceConfig.clearRepositories();
        if (gitConfig != null && !CoreUtils.isNullOrEmpty(gitConfig.repositories())) {
            for (ConfigurationServiceGitRepository repository : gitConfig.repositories()) {
                this.configurationServiceConfig.addRepository(repository);
            }
        }
        return this;
    }

    @Override
    public SpringServiceImpl withoutGitRepository(String name) {
        this.configurationServiceConfig.removeRepository(name);
        return this;
    }

    @Override
    public SpringServiceImpl withoutGitRepositories() {
        this.configurationServiceConfig.clearRepositories();
        return this;
    }

    private void prepareCreateOrUpdateConfigurationService() {
        List<ConfigurationServiceGitRepository> repositories = this.configurationServiceConfig.mergeRepositories();
        this.configurationServices.prepareCreateOrUpdate(new ConfigurationServiceGitProperty().withRepositories(repositories));
    }

    private void prepareCreateServiceRegistry() {
        this.serviceRegistries.prepareCreate();
    }

    private boolean isInUpdateMode() {
        return !this.isInCreateMode();
    }

    boolean isEnterpriseTier() {
        return ((ServiceResourceInner)((Object)this.innerModel())).sku() != null && SkuName.E0.toString().equals(((ServiceResourceInner)((Object)this.innerModel())).sku().name());
    }

    private void clearCache() {
        this.configurationServices.clear();
        this.configurationServiceConfig.reset();
        this.serviceRegistries.clear();
    }

    private Mono<BuildServiceInner> createDefaultBuildServiceAsync() {
        return ((AppPlatformManagementClient)((AppPlatformManager)this.manager()).serviceClient()).getBuildServices().createOrUpdateAsync(this.resourceGroupName(), this.name(), "default", new BuildServiceInner().withProperties(new BuildServiceProperties()));
    }

    private Mono<BuildServiceAgentPoolResourceInner> initializeDefaultBuildServiceAgentPoolAsync() {
        return ((AppPlatformManagementClient)((AppPlatformManager)this.manager()).serviceClient()).getBuildServiceAgentPools().updatePutAsync(this.resourceGroupName(), this.name(), "default", "default", new BuildServiceAgentPoolResourceInner().withProperties(new BuildServiceAgentPoolProperties().withPoolSize(new BuildServiceAgentPoolSizeProperties().withName("S1"))));
    }

    private class ConfigurationServiceConfig {
        private final Map<String, ConfigurationServiceGitRepository> gitRepositoryMap = new ConcurrentHashMap<String, ConfigurationServiceGitRepository>();
        private final Set<String> repositoriesToDelete = new HashSet<String>();
        private boolean update;
        private boolean clearRepositories;

        private ConfigurationServiceConfig() {
        }

        boolean needCreateOrUpdate() {
            return this.update;
        }

        public void clearUpdate() {
            this.update = false;
        }

        void reset() {
            this.gitRepositoryMap.clear();
            this.update = false;
            this.repositoriesToDelete.clear();
            this.clearRepositories = false;
        }

        public void addRepository(ConfigurationServiceGitRepository repository) {
            this.gitRepositoryMap.putIfAbsent(repository.name(), repository);
            this.update = true;
        }

        public void clearRepositories() {
            this.gitRepositoryMap.clear();
            this.clearRepositories = true;
            this.update = true;
        }

        public void removeRepository(String name) {
            this.repositoriesToDelete.add(name);
            this.update = true;
        }

        public List<ConfigurationServiceGitRepository> mergeRepositories() {
            SpringConfigurationService configurationService;
            if (this.clearRepositories) {
                return new ArrayList<ConfigurationServiceGitRepository>(this.gitRepositoryMap.values());
            }
            HashMap<String, ConfigurationServiceGitRepository> existingGitRepositories = new HashMap<String, ConfigurationServiceGitRepository>();
            if (SpringServiceImpl.this.isInUpdateMode() && (configurationService = SpringServiceImpl.this.getDefaultConfigurationService()) != null) {
                List<ConfigurationServiceGitRepository> repositoryList;
                List<ConfigurationServiceGitRepository> list = repositoryList = ((ConfigurationServiceResourceInner)((Object)configurationService.innerModel())).properties().settings() == null ? Collections.emptyList() : ((ConfigurationServiceResourceInner)((Object)configurationService.innerModel())).properties().settings().gitProperty().repositories();
                if (repositoryList != null) {
                    repositoryList.forEach(repository -> existingGitRepositories.put(repository.name(), (ConfigurationServiceGitRepository)repository));
                }
            }
            existingGitRepositories.putAll(this.gitRepositoryMap);
            for (String repositoryToDelete : this.repositoriesToDelete) {
                existingGitRepositories.remove(repositoryToDelete);
            }
            return new ArrayList<ConfigurationServiceGitRepository>(existingGitRepositories.values());
        }
    }
}

