/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.appplatform.fluent.BuildServicesClient;
import com.azure.resourcemanager.appplatform.fluent.models.BuildInner;
import com.azure.resourcemanager.appplatform.fluent.models.BuildResultInner;
import com.azure.resourcemanager.appplatform.fluent.models.BuildResultLogInner;
import com.azure.resourcemanager.appplatform.fluent.models.BuildServiceInner;
import com.azure.resourcemanager.appplatform.fluent.models.SupportedBuildpackResourceInner;
import com.azure.resourcemanager.appplatform.fluent.models.SupportedBuildpacksCollectionInner;
import com.azure.resourcemanager.appplatform.fluent.models.SupportedStackResourceInner;
import com.azure.resourcemanager.appplatform.fluent.models.SupportedStacksCollectionInner;
import com.azure.resourcemanager.appplatform.implementation.AppPlatformManagementClientImpl;
import com.azure.resourcemanager.appplatform.models.BuildCollection;
import com.azure.resourcemanager.appplatform.models.BuildResultCollection;
import com.azure.resourcemanager.appplatform.models.BuildServiceCollection;
import com.azure.resourcemanager.appplatform.models.ResourceUploadDefinition;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class BuildServicesClientImpl
implements BuildServicesClient {
    private final BuildServicesService service;
    private final AppPlatformManagementClientImpl client;

    BuildServicesClientImpl(AppPlatformManagementClientImpl client) {
        this.service = (BuildServicesService)RestProxy.create(BuildServicesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BuildServiceInner>> listBuildServicesSinglePageAsync(String resourceGroupName, String serviceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBuildServices(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BuildServiceCollection)res.getValue()).value(), ((BuildServiceCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BuildServiceInner>> listBuildServicesSinglePageAsync(String resourceGroupName, String serviceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBuildServices(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BuildServiceCollection)res.getValue()).value(), ((BuildServiceCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BuildServiceInner> listBuildServicesAsync(String resourceGroupName, String serviceName) {
        return new PagedFlux(() -> this.listBuildServicesSinglePageAsync(resourceGroupName, serviceName), nextLink -> this.listBuildServicesNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<BuildServiceInner> listBuildServicesAsync(String resourceGroupName, String serviceName, Context context) {
        return new PagedFlux(() -> this.listBuildServicesSinglePageAsync(resourceGroupName, serviceName, context), nextLink -> this.listBuildServicesNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BuildServiceInner> listBuildServices(String resourceGroupName, String serviceName) {
        return new PagedIterable(this.listBuildServicesAsync(resourceGroupName, serviceName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BuildServiceInner> listBuildServices(String resourceGroupName, String serviceName, Context context) {
        return new PagedIterable(this.listBuildServicesAsync(resourceGroupName, serviceName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BuildServiceInner>> getBuildServiceWithResponseAsync(String resourceGroupName, String serviceName, String buildServiceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getBuildService(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BuildServiceInner>> getBuildServiceWithResponseAsync(String resourceGroupName, String serviceName, String buildServiceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getBuildService(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BuildServiceInner> getBuildServiceAsync(String resourceGroupName, String serviceName, String buildServiceName) {
        return this.getBuildServiceWithResponseAsync(resourceGroupName, serviceName, buildServiceName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((BuildServiceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BuildServiceInner> getBuildServiceWithResponse(String resourceGroupName, String serviceName, String buildServiceName, Context context) {
        return (Response)this.getBuildServiceWithResponseAsync(resourceGroupName, serviceName, buildServiceName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BuildServiceInner getBuildService(String resourceGroupName, String serviceName, String buildServiceName) {
        return (BuildServiceInner)((Object)this.getBuildServiceWithResponse(resourceGroupName, serviceName, buildServiceName, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName, String buildServiceName, BuildServiceInner buildService) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        if (buildService == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildService is required and cannot be null."));
        }
        buildService.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, buildService, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName, String buildServiceName, BuildServiceInner buildService, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        if (buildService == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildService is required and cannot be null."));
        }
        buildService.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, buildService, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<BuildServiceInner>, BuildServiceInner> beginCreateOrUpdateAsync(String resourceGroupName, String serviceName, String buildServiceName, BuildServiceInner buildService) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, buildServiceName, buildService);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)BuildServiceInner.class), (Type)((Object)BuildServiceInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<BuildServiceInner>, BuildServiceInner> beginCreateOrUpdateAsync(String resourceGroupName, String serviceName, String buildServiceName, BuildServiceInner buildService, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, buildServiceName, buildService, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)BuildServiceInner.class), (Type)((Object)BuildServiceInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<BuildServiceInner>, BuildServiceInner> beginCreateOrUpdate(String resourceGroupName, String serviceName, String buildServiceName, BuildServiceInner buildService) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, buildServiceName, buildService).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<BuildServiceInner>, BuildServiceInner> beginCreateOrUpdate(String resourceGroupName, String serviceName, String buildServiceName, BuildServiceInner buildService, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, buildServiceName, buildService, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BuildServiceInner> createOrUpdateAsync(String resourceGroupName, String serviceName, String buildServiceName, BuildServiceInner buildService) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, buildServiceName, buildService).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<BuildServiceInner> createOrUpdateAsync(String resourceGroupName, String serviceName, String buildServiceName, BuildServiceInner buildService, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, buildServiceName, buildService, context).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BuildServiceInner createOrUpdate(String resourceGroupName, String serviceName, String buildServiceName, BuildServiceInner buildService) {
        return (BuildServiceInner)((Object)this.createOrUpdateAsync(resourceGroupName, serviceName, buildServiceName, buildService).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BuildServiceInner createOrUpdate(String resourceGroupName, String serviceName, String buildServiceName, BuildServiceInner buildService, Context context) {
        return (BuildServiceInner)((Object)this.createOrUpdateAsync(resourceGroupName, serviceName, buildServiceName, buildService, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BuildInner>> listBuildsSinglePageAsync(String resourceGroupName, String serviceName, String buildServiceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBuilds(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BuildCollection)res.getValue()).value(), ((BuildCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BuildInner>> listBuildsSinglePageAsync(String resourceGroupName, String serviceName, String buildServiceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBuilds(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BuildCollection)res.getValue()).value(), ((BuildCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BuildInner> listBuildsAsync(String resourceGroupName, String serviceName, String buildServiceName) {
        return new PagedFlux(() -> this.listBuildsSinglePageAsync(resourceGroupName, serviceName, buildServiceName), nextLink -> this.listBuildsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<BuildInner> listBuildsAsync(String resourceGroupName, String serviceName, String buildServiceName, Context context) {
        return new PagedFlux(() -> this.listBuildsSinglePageAsync(resourceGroupName, serviceName, buildServiceName, context), nextLink -> this.listBuildsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BuildInner> listBuilds(String resourceGroupName, String serviceName, String buildServiceName) {
        return new PagedIterable(this.listBuildsAsync(resourceGroupName, serviceName, buildServiceName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BuildInner> listBuilds(String resourceGroupName, String serviceName, String buildServiceName, Context context) {
        return new PagedIterable(this.listBuildsAsync(resourceGroupName, serviceName, buildServiceName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BuildInner>> getBuildWithResponseAsync(String resourceGroupName, String serviceName, String buildServiceName, String buildName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        if (buildName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getBuild(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, buildName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BuildInner>> getBuildWithResponseAsync(String resourceGroupName, String serviceName, String buildServiceName, String buildName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        if (buildName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getBuild(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, buildName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BuildInner> getBuildAsync(String resourceGroupName, String serviceName, String buildServiceName, String buildName) {
        return this.getBuildWithResponseAsync(resourceGroupName, serviceName, buildServiceName, buildName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((BuildInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BuildInner> getBuildWithResponse(String resourceGroupName, String serviceName, String buildServiceName, String buildName, Context context) {
        return (Response)this.getBuildWithResponseAsync(resourceGroupName, serviceName, buildServiceName, buildName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BuildInner getBuild(String resourceGroupName, String serviceName, String buildServiceName, String buildName) {
        return (BuildInner)((Object)this.getBuildWithResponse(resourceGroupName, serviceName, buildServiceName, buildName, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BuildInner>> createOrUpdateBuildWithResponseAsync(String resourceGroupName, String serviceName, String buildServiceName, String buildName, BuildInner build) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        if (buildName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildName is required and cannot be null."));
        }
        if (build == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter build is required and cannot be null."));
        }
        build.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateBuild(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, buildName, build, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BuildInner>> createOrUpdateBuildWithResponseAsync(String resourceGroupName, String serviceName, String buildServiceName, String buildName, BuildInner build, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        if (buildName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildName is required and cannot be null."));
        }
        if (build == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter build is required and cannot be null."));
        }
        build.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdateBuild(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, buildName, build, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BuildInner> createOrUpdateBuildAsync(String resourceGroupName, String serviceName, String buildServiceName, String buildName, BuildInner build) {
        return this.createOrUpdateBuildWithResponseAsync(resourceGroupName, serviceName, buildServiceName, buildName, build).flatMap(res -> Mono.justOrEmpty((Object)((Object)((BuildInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BuildInner> createOrUpdateBuildWithResponse(String resourceGroupName, String serviceName, String buildServiceName, String buildName, BuildInner build, Context context) {
        return (Response)this.createOrUpdateBuildWithResponseAsync(resourceGroupName, serviceName, buildServiceName, buildName, build, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BuildInner createOrUpdateBuild(String resourceGroupName, String serviceName, String buildServiceName, String buildName, BuildInner build) {
        return (BuildInner)((Object)this.createOrUpdateBuildWithResponse(resourceGroupName, serviceName, buildServiceName, buildName, build, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteBuildWithResponseAsync(String resourceGroupName, String serviceName, String buildServiceName, String buildName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        if (buildName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteBuild(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, buildName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteBuildWithResponseAsync(String resourceGroupName, String serviceName, String buildServiceName, String buildName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        if (buildName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteBuild(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, buildName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteBuildAsync(String resourceGroupName, String serviceName, String buildServiceName, String buildName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteBuildWithResponseAsync(resourceGroupName, serviceName, buildServiceName, buildName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteBuildAsync(String resourceGroupName, String serviceName, String buildServiceName, String buildName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteBuildWithResponseAsync(resourceGroupName, serviceName, buildServiceName, buildName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteBuild(String resourceGroupName, String serviceName, String buildServiceName, String buildName) {
        return this.beginDeleteBuildAsync(resourceGroupName, serviceName, buildServiceName, buildName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteBuild(String resourceGroupName, String serviceName, String buildServiceName, String buildName, Context context) {
        return this.beginDeleteBuildAsync(resourceGroupName, serviceName, buildServiceName, buildName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteBuildAsync(String resourceGroupName, String serviceName, String buildServiceName, String buildName) {
        return this.beginDeleteBuildAsync(resourceGroupName, serviceName, buildServiceName, buildName).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteBuildAsync(String resourceGroupName, String serviceName, String buildServiceName, String buildName, Context context) {
        return this.beginDeleteBuildAsync(resourceGroupName, serviceName, buildServiceName, buildName, context).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteBuild(String resourceGroupName, String serviceName, String buildServiceName, String buildName) {
        this.deleteBuildAsync(resourceGroupName, serviceName, buildServiceName, buildName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteBuild(String resourceGroupName, String serviceName, String buildServiceName, String buildName, Context context) {
        this.deleteBuildAsync(resourceGroupName, serviceName, buildServiceName, buildName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BuildResultInner>> listBuildResultsSinglePageAsync(String resourceGroupName, String serviceName, String buildServiceName, String buildName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        if (buildName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBuildResults(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, buildName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BuildResultCollection)res.getValue()).value(), ((BuildResultCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BuildResultInner>> listBuildResultsSinglePageAsync(String resourceGroupName, String serviceName, String buildServiceName, String buildName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        if (buildName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBuildResults(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, buildName, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BuildResultCollection)res.getValue()).value(), ((BuildResultCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BuildResultInner> listBuildResultsAsync(String resourceGroupName, String serviceName, String buildServiceName, String buildName) {
        return new PagedFlux(() -> this.listBuildResultsSinglePageAsync(resourceGroupName, serviceName, buildServiceName, buildName), nextLink -> this.listBuildResultsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<BuildResultInner> listBuildResultsAsync(String resourceGroupName, String serviceName, String buildServiceName, String buildName, Context context) {
        return new PagedFlux(() -> this.listBuildResultsSinglePageAsync(resourceGroupName, serviceName, buildServiceName, buildName, context), nextLink -> this.listBuildResultsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BuildResultInner> listBuildResults(String resourceGroupName, String serviceName, String buildServiceName, String buildName) {
        return new PagedIterable(this.listBuildResultsAsync(resourceGroupName, serviceName, buildServiceName, buildName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BuildResultInner> listBuildResults(String resourceGroupName, String serviceName, String buildServiceName, String buildName, Context context) {
        return new PagedIterable(this.listBuildResultsAsync(resourceGroupName, serviceName, buildServiceName, buildName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BuildResultInner>> getBuildResultWithResponseAsync(String resourceGroupName, String serviceName, String buildServiceName, String buildName, String buildResultName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        if (buildName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildName is required and cannot be null."));
        }
        if (buildResultName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildResultName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getBuildResult(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, buildName, buildResultName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BuildResultInner>> getBuildResultWithResponseAsync(String resourceGroupName, String serviceName, String buildServiceName, String buildName, String buildResultName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        if (buildName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildName is required and cannot be null."));
        }
        if (buildResultName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildResultName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getBuildResult(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, buildName, buildResultName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BuildResultInner> getBuildResultAsync(String resourceGroupName, String serviceName, String buildServiceName, String buildName, String buildResultName) {
        return this.getBuildResultWithResponseAsync(resourceGroupName, serviceName, buildServiceName, buildName, buildResultName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((BuildResultInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BuildResultInner> getBuildResultWithResponse(String resourceGroupName, String serviceName, String buildServiceName, String buildName, String buildResultName, Context context) {
        return (Response)this.getBuildResultWithResponseAsync(resourceGroupName, serviceName, buildServiceName, buildName, buildResultName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BuildResultInner getBuildResult(String resourceGroupName, String serviceName, String buildServiceName, String buildName, String buildResultName) {
        return (BuildResultInner)((Object)this.getBuildResultWithResponse(resourceGroupName, serviceName, buildServiceName, buildName, buildResultName, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BuildResultLogInner>> getBuildResultLogWithResponseAsync(String resourceGroupName, String serviceName, String buildServiceName, String buildName, String buildResultName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        if (buildName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildName is required and cannot be null."));
        }
        if (buildResultName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildResultName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getBuildResultLog(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, buildName, buildResultName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BuildResultLogInner>> getBuildResultLogWithResponseAsync(String resourceGroupName, String serviceName, String buildServiceName, String buildName, String buildResultName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        if (buildName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildName is required and cannot be null."));
        }
        if (buildResultName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildResultName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getBuildResultLog(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, buildName, buildResultName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BuildResultLogInner> getBuildResultLogAsync(String resourceGroupName, String serviceName, String buildServiceName, String buildName, String buildResultName) {
        return this.getBuildResultLogWithResponseAsync(resourceGroupName, serviceName, buildServiceName, buildName, buildResultName).flatMap(res -> Mono.justOrEmpty((Object)((BuildResultLogInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BuildResultLogInner> getBuildResultLogWithResponse(String resourceGroupName, String serviceName, String buildServiceName, String buildName, String buildResultName, Context context) {
        return (Response)this.getBuildResultLogWithResponseAsync(resourceGroupName, serviceName, buildServiceName, buildName, buildResultName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BuildResultLogInner getBuildResultLog(String resourceGroupName, String serviceName, String buildServiceName, String buildName, String buildResultName) {
        return (BuildResultLogInner)this.getBuildResultLogWithResponse(resourceGroupName, serviceName, buildServiceName, buildName, buildResultName, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ResourceUploadDefinition>> getResourceUploadUrlWithResponseAsync(String resourceGroupName, String serviceName, String buildServiceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getResourceUploadUrl(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ResourceUploadDefinition>> getResourceUploadUrlWithResponseAsync(String resourceGroupName, String serviceName, String buildServiceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getResourceUploadUrl(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResourceUploadDefinition> getResourceUploadUrlAsync(String resourceGroupName, String serviceName, String buildServiceName) {
        return this.getResourceUploadUrlWithResponseAsync(resourceGroupName, serviceName, buildServiceName).flatMap(res -> Mono.justOrEmpty((Object)((ResourceUploadDefinition)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ResourceUploadDefinition> getResourceUploadUrlWithResponse(String resourceGroupName, String serviceName, String buildServiceName, Context context) {
        return (Response)this.getResourceUploadUrlWithResponseAsync(resourceGroupName, serviceName, buildServiceName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResourceUploadDefinition getResourceUploadUrl(String resourceGroupName, String serviceName, String buildServiceName) {
        return (ResourceUploadDefinition)this.getResourceUploadUrlWithResponse(resourceGroupName, serviceName, buildServiceName, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SupportedBuildpacksCollectionInner>> listSupportedBuildpacksWithResponseAsync(String resourceGroupName, String serviceName, String buildServiceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listSupportedBuildpacks(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SupportedBuildpacksCollectionInner>> listSupportedBuildpacksWithResponseAsync(String resourceGroupName, String serviceName, String buildServiceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listSupportedBuildpacks(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SupportedBuildpacksCollectionInner> listSupportedBuildpacksAsync(String resourceGroupName, String serviceName, String buildServiceName) {
        return this.listSupportedBuildpacksWithResponseAsync(resourceGroupName, serviceName, buildServiceName).flatMap(res -> Mono.justOrEmpty((Object)((SupportedBuildpacksCollectionInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SupportedBuildpacksCollectionInner> listSupportedBuildpacksWithResponse(String resourceGroupName, String serviceName, String buildServiceName, Context context) {
        return (Response)this.listSupportedBuildpacksWithResponseAsync(resourceGroupName, serviceName, buildServiceName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SupportedBuildpacksCollectionInner listSupportedBuildpacks(String resourceGroupName, String serviceName, String buildServiceName) {
        return (SupportedBuildpacksCollectionInner)this.listSupportedBuildpacksWithResponse(resourceGroupName, serviceName, buildServiceName, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SupportedBuildpackResourceInner>> getSupportedBuildpackWithResponseAsync(String resourceGroupName, String serviceName, String buildServiceName, String buildpackName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        if (buildpackName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildpackName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSupportedBuildpack(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, buildpackName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SupportedBuildpackResourceInner>> getSupportedBuildpackWithResponseAsync(String resourceGroupName, String serviceName, String buildServiceName, String buildpackName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        if (buildpackName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildpackName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getSupportedBuildpack(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, buildpackName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SupportedBuildpackResourceInner> getSupportedBuildpackAsync(String resourceGroupName, String serviceName, String buildServiceName, String buildpackName) {
        return this.getSupportedBuildpackWithResponseAsync(resourceGroupName, serviceName, buildServiceName, buildpackName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((SupportedBuildpackResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SupportedBuildpackResourceInner> getSupportedBuildpackWithResponse(String resourceGroupName, String serviceName, String buildServiceName, String buildpackName, Context context) {
        return (Response)this.getSupportedBuildpackWithResponseAsync(resourceGroupName, serviceName, buildServiceName, buildpackName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SupportedBuildpackResourceInner getSupportedBuildpack(String resourceGroupName, String serviceName, String buildServiceName, String buildpackName) {
        return (SupportedBuildpackResourceInner)((Object)this.getSupportedBuildpackWithResponse(resourceGroupName, serviceName, buildServiceName, buildpackName, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SupportedStacksCollectionInner>> listSupportedStacksWithResponseAsync(String resourceGroupName, String serviceName, String buildServiceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listSupportedStacks(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SupportedStacksCollectionInner>> listSupportedStacksWithResponseAsync(String resourceGroupName, String serviceName, String buildServiceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listSupportedStacks(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SupportedStacksCollectionInner> listSupportedStacksAsync(String resourceGroupName, String serviceName, String buildServiceName) {
        return this.listSupportedStacksWithResponseAsync(resourceGroupName, serviceName, buildServiceName).flatMap(res -> Mono.justOrEmpty((Object)((SupportedStacksCollectionInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SupportedStacksCollectionInner> listSupportedStacksWithResponse(String resourceGroupName, String serviceName, String buildServiceName, Context context) {
        return (Response)this.listSupportedStacksWithResponseAsync(resourceGroupName, serviceName, buildServiceName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SupportedStacksCollectionInner listSupportedStacks(String resourceGroupName, String serviceName, String buildServiceName) {
        return (SupportedStacksCollectionInner)this.listSupportedStacksWithResponse(resourceGroupName, serviceName, buildServiceName, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SupportedStackResourceInner>> getSupportedStackWithResponseAsync(String resourceGroupName, String serviceName, String buildServiceName, String stackName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        if (stackName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter stackName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSupportedStack(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, stackName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SupportedStackResourceInner>> getSupportedStackWithResponseAsync(String resourceGroupName, String serviceName, String buildServiceName, String stackName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        if (stackName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter stackName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getSupportedStack(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, stackName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SupportedStackResourceInner> getSupportedStackAsync(String resourceGroupName, String serviceName, String buildServiceName, String stackName) {
        return this.getSupportedStackWithResponseAsync(resourceGroupName, serviceName, buildServiceName, stackName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((SupportedStackResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SupportedStackResourceInner> getSupportedStackWithResponse(String resourceGroupName, String serviceName, String buildServiceName, String stackName, Context context) {
        return (Response)this.getSupportedStackWithResponseAsync(resourceGroupName, serviceName, buildServiceName, stackName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SupportedStackResourceInner getSupportedStack(String resourceGroupName, String serviceName, String buildServiceName, String stackName) {
        return (SupportedStackResourceInner)((Object)this.getSupportedStackWithResponse(resourceGroupName, serviceName, buildServiceName, stackName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BuildServiceInner>> listBuildServicesNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBuildServicesNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BuildServiceCollection)res.getValue()).value(), ((BuildServiceCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BuildServiceInner>> listBuildServicesNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBuildServicesNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BuildServiceCollection)res.getValue()).value(), ((BuildServiceCollection)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BuildInner>> listBuildsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBuildsNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BuildCollection)res.getValue()).value(), ((BuildCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BuildInner>> listBuildsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBuildsNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BuildCollection)res.getValue()).value(), ((BuildCollection)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BuildResultInner>> listBuildResultsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBuildResultsNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BuildResultCollection)res.getValue()).value(), ((BuildResultCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BuildResultInner>> listBuildResultsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBuildResultsNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BuildResultCollection)res.getValue()).value(), ((BuildResultCollection)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AppPlatformManagemen")
    public static interface BuildServicesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BuildServiceCollection>> listBuildServices(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BuildServiceInner>> getBuildService(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="buildServiceName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="buildServiceName") String var6, @BodyParam(value="application/json") BuildServiceInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builds")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BuildCollection>> listBuilds(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="buildServiceName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builds/{buildName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BuildInner>> getBuild(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="buildServiceName") String var6, @PathParam(value="buildName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builds/{buildName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BuildInner>> createOrUpdateBuild(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="buildServiceName") String var6, @PathParam(value="buildName") String var7, @BodyParam(value="application/json") BuildInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builds/{buildName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> deleteBuild(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="buildServiceName") String var6, @PathParam(value="buildName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builds/{buildName}/results")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BuildResultCollection>> listBuildResults(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="buildServiceName") String var6, @PathParam(value="buildName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builds/{buildName}/results/{buildResultName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BuildResultInner>> getBuildResult(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="buildServiceName") String var6, @PathParam(value="buildName") String var7, @PathParam(value="buildResultName") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builds/{buildName}/results/{buildResultName}/getLogFileUrl")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BuildResultLogInner>> getBuildResultLog(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="buildServiceName") String var6, @PathParam(value="buildName") String var7, @PathParam(value="buildResultName") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/getResourceUploadUrl")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ResourceUploadDefinition>> getResourceUploadUrl(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="buildServiceName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/supportedBuildpacks")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SupportedBuildpacksCollectionInner>> listSupportedBuildpacks(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="buildServiceName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/supportedBuildpacks/{buildpackName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SupportedBuildpackResourceInner>> getSupportedBuildpack(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="buildServiceName") String var6, @PathParam(value="buildpackName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/supportedStacks")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SupportedStacksCollectionInner>> listSupportedStacks(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="buildServiceName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/supportedStacks/{stackName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SupportedStackResourceInner>> getSupportedStack(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="buildServiceName") String var6, @PathParam(value="stackName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BuildServiceCollection>> listBuildServicesNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BuildCollection>> listBuildsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BuildResultCollection>> listBuildResultsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

