/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.LifecycleType;
import java.io.IOException;

public final class LifecycleConfiguration
implements JsonSerializable<LifecycleConfiguration> {
    private LifecycleType lifecycleType;
    private Integer cooldownPeriodInSeconds;
    private Integer maxAlivePeriodInSeconds;

    public LifecycleType lifecycleType() {
        return this.lifecycleType;
    }

    public LifecycleConfiguration withLifecycleType(LifecycleType lifecycleType) {
        this.lifecycleType = lifecycleType;
        return this;
    }

    public Integer cooldownPeriodInSeconds() {
        return this.cooldownPeriodInSeconds;
    }

    public LifecycleConfiguration withCooldownPeriodInSeconds(Integer cooldownPeriodInSeconds) {
        this.cooldownPeriodInSeconds = cooldownPeriodInSeconds;
        return this;
    }

    public Integer maxAlivePeriodInSeconds() {
        return this.maxAlivePeriodInSeconds;
    }

    public LifecycleConfiguration withMaxAlivePeriodInSeconds(Integer maxAlivePeriodInSeconds) {
        this.maxAlivePeriodInSeconds = maxAlivePeriodInSeconds;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("lifecycleType", this.lifecycleType == null ? null : this.lifecycleType.toString());
        jsonWriter.writeNumberField("cooldownPeriodInSeconds", (Number)this.cooldownPeriodInSeconds);
        jsonWriter.writeNumberField("maxAlivePeriodInSeconds", (Number)this.maxAlivePeriodInSeconds);
        return jsonWriter.writeEndObject();
    }

    public static LifecycleConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (LifecycleConfiguration)jsonReader.readObject(reader -> {
            LifecycleConfiguration deserializedLifecycleConfiguration = new LifecycleConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("lifecycleType".equals(fieldName)) {
                    deserializedLifecycleConfiguration.lifecycleType = LifecycleType.fromString(reader.getString());
                    continue;
                }
                if ("cooldownPeriodInSeconds".equals(fieldName)) {
                    deserializedLifecycleConfiguration.cooldownPeriodInSeconds = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("maxAlivePeriodInSeconds".equals(fieldName)) {
                    deserializedLifecycleConfiguration.maxAlivePeriodInSeconds = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLifecycleConfiguration;
        });
    }
}

