/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.HttpRoute;
import com.azure.resourcemanager.appcontainers.models.HttpRouteTarget;
import java.io.IOException;
import java.util.List;

public final class HttpRouteRule
implements JsonSerializable<HttpRouteRule> {
    private List<HttpRouteTarget> targets;
    private List<HttpRoute> routes;
    private String description;

    public List<HttpRouteTarget> targets() {
        return this.targets;
    }

    public HttpRouteRule withTargets(List<HttpRouteTarget> targets) {
        this.targets = targets;
        return this;
    }

    public List<HttpRoute> routes() {
        return this.routes;
    }

    public HttpRouteRule withRoutes(List<HttpRoute> routes) {
        this.routes = routes;
        return this;
    }

    public String description() {
        return this.description;
    }

    public HttpRouteRule withDescription(String description) {
        this.description = description;
        return this;
    }

    public void validate() {
        if (this.targets() != null) {
            this.targets().forEach(e -> e.validate());
        }
        if (this.routes() != null) {
            this.routes().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("targets", this.targets, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("routes", this.routes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static HttpRouteRule fromJson(JsonReader jsonReader) throws IOException {
        return (HttpRouteRule)jsonReader.readObject(reader -> {
            HttpRouteRule deserializedHttpRouteRule = new HttpRouteRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targets".equals(fieldName)) {
                    List targets;
                    deserializedHttpRouteRule.targets = targets = reader.readArray(reader1 -> HttpRouteTarget.fromJson(reader1));
                    continue;
                }
                if ("routes".equals(fieldName)) {
                    List routes;
                    deserializedHttpRouteRule.routes = routes = reader.readArray(reader1 -> HttpRoute.fromJson(reader1));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedHttpRouteRule.description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHttpRouteRule;
        });
    }
}

