/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.CustomDomain;
import com.azure.resourcemanager.appcontainers.models.HttpRouteProvisioningErrors;
import com.azure.resourcemanager.appcontainers.models.HttpRouteProvisioningState;
import com.azure.resourcemanager.appcontainers.models.HttpRouteRule;
import java.io.IOException;
import java.util.List;

public final class HttpRouteConfigProperties
implements JsonSerializable<HttpRouteConfigProperties> {
    private HttpRouteProvisioningState provisioningState;
    private List<HttpRouteProvisioningErrors> provisioningErrors;
    private String fqdn;
    private List<CustomDomain> customDomains;
    private List<HttpRouteRule> rules;

    public HttpRouteProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public List<HttpRouteProvisioningErrors> provisioningErrors() {
        return this.provisioningErrors;
    }

    public String fqdn() {
        return this.fqdn;
    }

    public List<CustomDomain> customDomains() {
        return this.customDomains;
    }

    public HttpRouteConfigProperties withCustomDomains(List<CustomDomain> customDomains) {
        this.customDomains = customDomains;
        return this;
    }

    public List<HttpRouteRule> rules() {
        return this.rules;
    }

    public HttpRouteConfigProperties withRules(List<HttpRouteRule> rules) {
        this.rules = rules;
        return this;
    }

    public void validate() {
        if (this.provisioningErrors() != null) {
            this.provisioningErrors().forEach(e -> e.validate());
        }
        if (this.customDomains() != null) {
            this.customDomains().forEach(e -> e.validate());
        }
        if (this.rules() != null) {
            this.rules().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("customDomains", this.customDomains, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("rules", this.rules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static HttpRouteConfigProperties fromJson(JsonReader jsonReader) throws IOException {
        return (HttpRouteConfigProperties)jsonReader.readObject(reader -> {
            HttpRouteConfigProperties deserializedHttpRouteConfigProperties = new HttpRouteConfigProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedHttpRouteConfigProperties.provisioningState = HttpRouteProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("provisioningErrors".equals(fieldName)) {
                    List provisioningErrors;
                    deserializedHttpRouteConfigProperties.provisioningErrors = provisioningErrors = reader.readArray(reader1 -> HttpRouteProvisioningErrors.fromJson(reader1));
                    continue;
                }
                if ("fqdn".equals(fieldName)) {
                    deserializedHttpRouteConfigProperties.fqdn = reader.getString();
                    continue;
                }
                if ("customDomains".equals(fieldName)) {
                    List customDomains;
                    deserializedHttpRouteConfigProperties.customDomains = customDomains = reader.readArray(reader1 -> CustomDomain.fromJson(reader1));
                    continue;
                }
                if ("rules".equals(fieldName)) {
                    List rules;
                    deserializedHttpRouteConfigProperties.rules = rules = reader.readArray(reader1 -> HttpRouteRule.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHttpRouteConfigProperties;
        });
    }
}

