/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.fluent.models.HttpRouteConfigInner;
import java.io.IOException;
import java.util.List;

public final class HttpRouteConfigCollection
implements JsonSerializable<HttpRouteConfigCollection> {
    private List<HttpRouteConfigInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(HttpRouteConfigCollection.class);

    public List<HttpRouteConfigInner> value() {
        return this.value;
    }

    public HttpRouteConfigCollection withValue(List<HttpRouteConfigInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model HttpRouteConfigCollection"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static HttpRouteConfigCollection fromJson(JsonReader jsonReader) throws IOException {
        return (HttpRouteConfigCollection)jsonReader.readObject(reader -> {
            HttpRouteConfigCollection deserializedHttpRouteConfigCollection = new HttpRouteConfigCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedHttpRouteConfigCollection.value = value = reader.readArray(reader1 -> HttpRouteConfigInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedHttpRouteConfigCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHttpRouteConfigCollection;
        });
    }
}

