/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class CorsPolicy
implements JsonSerializable<CorsPolicy> {
    private List<String> allowedOrigins;
    private List<String> allowedMethods;
    private List<String> allowedHeaders;
    private List<String> exposeHeaders;
    private Integer maxAge;
    private Boolean allowCredentials;
    private static final ClientLogger LOGGER = new ClientLogger(CorsPolicy.class);

    public List<String> allowedOrigins() {
        return this.allowedOrigins;
    }

    public CorsPolicy withAllowedOrigins(List<String> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
        return this;
    }

    public List<String> allowedMethods() {
        return this.allowedMethods;
    }

    public CorsPolicy withAllowedMethods(List<String> allowedMethods) {
        this.allowedMethods = allowedMethods;
        return this;
    }

    public List<String> allowedHeaders() {
        return this.allowedHeaders;
    }

    public CorsPolicy withAllowedHeaders(List<String> allowedHeaders) {
        this.allowedHeaders = allowedHeaders;
        return this;
    }

    public List<String> exposeHeaders() {
        return this.exposeHeaders;
    }

    public CorsPolicy withExposeHeaders(List<String> exposeHeaders) {
        this.exposeHeaders = exposeHeaders;
        return this;
    }

    public Integer maxAge() {
        return this.maxAge;
    }

    public CorsPolicy withMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    public Boolean allowCredentials() {
        return this.allowCredentials;
    }

    public CorsPolicy withAllowCredentials(Boolean allowCredentials) {
        this.allowCredentials = allowCredentials;
        return this;
    }

    public void validate() {
        if (this.allowedOrigins() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property allowedOrigins in model CorsPolicy"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("allowedOrigins", this.allowedOrigins, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("allowedMethods", this.allowedMethods, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("allowedHeaders", this.allowedHeaders, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("exposeHeaders", this.exposeHeaders, (writer, element) -> writer.writeString(element));
        jsonWriter.writeNumberField("maxAge", (Number)this.maxAge);
        jsonWriter.writeBooleanField("allowCredentials", this.allowCredentials);
        return jsonWriter.writeEndObject();
    }

    public static CorsPolicy fromJson(JsonReader jsonReader) throws IOException {
        return (CorsPolicy)jsonReader.readObject(reader -> {
            CorsPolicy deserializedCorsPolicy = new CorsPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("allowedOrigins".equals(fieldName)) {
                    List allowedOrigins;
                    deserializedCorsPolicy.allowedOrigins = allowedOrigins = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("allowedMethods".equals(fieldName)) {
                    List allowedMethods;
                    deserializedCorsPolicy.allowedMethods = allowedMethods = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("allowedHeaders".equals(fieldName)) {
                    List allowedHeaders;
                    deserializedCorsPolicy.allowedHeaders = allowedHeaders = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("exposeHeaders".equals(fieldName)) {
                    List exposeHeaders;
                    deserializedCorsPolicy.exposeHeaders = exposeHeaders = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("maxAge".equals(fieldName)) {
                    deserializedCorsPolicy.maxAge = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("allowCredentials".equals(fieldName)) {
                    deserializedCorsPolicy.allowCredentials = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCorsPolicy;
        });
    }
}

