/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.ActiveRevisionsMode;
import com.azure.resourcemanager.appcontainers.models.Dapr;
import com.azure.resourcemanager.appcontainers.models.IdentitySettings;
import com.azure.resourcemanager.appcontainers.models.Ingress;
import com.azure.resourcemanager.appcontainers.models.RegistryCredentials;
import com.azure.resourcemanager.appcontainers.models.Runtime;
import com.azure.resourcemanager.appcontainers.models.Secret;
import com.azure.resourcemanager.appcontainers.models.Service;
import java.io.IOException;
import java.util.List;

public final class Configuration
implements JsonSerializable<Configuration> {
    private List<Secret> secrets;
    private ActiveRevisionsMode activeRevisionsMode;
    private Ingress ingress;
    private List<RegistryCredentials> registries;
    private Dapr dapr;
    private Runtime runtime;
    private Integer maxInactiveRevisions;
    private Service service;
    private List<IdentitySettings> identitySettings;

    public List<Secret> secrets() {
        return this.secrets;
    }

    public Configuration withSecrets(List<Secret> secrets) {
        this.secrets = secrets;
        return this;
    }

    public ActiveRevisionsMode activeRevisionsMode() {
        return this.activeRevisionsMode;
    }

    public Configuration withActiveRevisionsMode(ActiveRevisionsMode activeRevisionsMode) {
        this.activeRevisionsMode = activeRevisionsMode;
        return this;
    }

    public Ingress ingress() {
        return this.ingress;
    }

    public Configuration withIngress(Ingress ingress) {
        this.ingress = ingress;
        return this;
    }

    public List<RegistryCredentials> registries() {
        return this.registries;
    }

    public Configuration withRegistries(List<RegistryCredentials> registries) {
        this.registries = registries;
        return this;
    }

    public Dapr dapr() {
        return this.dapr;
    }

    public Configuration withDapr(Dapr dapr) {
        this.dapr = dapr;
        return this;
    }

    public Runtime runtime() {
        return this.runtime;
    }

    public Configuration withRuntime(Runtime runtime) {
        this.runtime = runtime;
        return this;
    }

    public Integer maxInactiveRevisions() {
        return this.maxInactiveRevisions;
    }

    public Configuration withMaxInactiveRevisions(Integer maxInactiveRevisions) {
        this.maxInactiveRevisions = maxInactiveRevisions;
        return this;
    }

    public Service service() {
        return this.service;
    }

    public Configuration withService(Service service) {
        this.service = service;
        return this;
    }

    public List<IdentitySettings> identitySettings() {
        return this.identitySettings;
    }

    public Configuration withIdentitySettings(List<IdentitySettings> identitySettings) {
        this.identitySettings = identitySettings;
        return this;
    }

    public void validate() {
        if (this.secrets() != null) {
            this.secrets().forEach(e -> e.validate());
        }
        if (this.ingress() != null) {
            this.ingress().validate();
        }
        if (this.registries() != null) {
            this.registries().forEach(e -> e.validate());
        }
        if (this.dapr() != null) {
            this.dapr().validate();
        }
        if (this.runtime() != null) {
            this.runtime().validate();
        }
        if (this.service() != null) {
            this.service().validate();
        }
        if (this.identitySettings() != null) {
            this.identitySettings().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("secrets", this.secrets, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("activeRevisionsMode", this.activeRevisionsMode == null ? null : this.activeRevisionsMode.toString());
        jsonWriter.writeJsonField("ingress", (JsonSerializable)this.ingress);
        jsonWriter.writeArrayField("registries", this.registries, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("dapr", (JsonSerializable)this.dapr);
        jsonWriter.writeJsonField("runtime", (JsonSerializable)this.runtime);
        jsonWriter.writeNumberField("maxInactiveRevisions", (Number)this.maxInactiveRevisions);
        jsonWriter.writeJsonField("service", (JsonSerializable)this.service);
        jsonWriter.writeArrayField("identitySettings", this.identitySettings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static Configuration fromJson(JsonReader jsonReader) throws IOException {
        return (Configuration)jsonReader.readObject(reader -> {
            Configuration deserializedConfiguration = new Configuration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("secrets".equals(fieldName)) {
                    List secrets;
                    deserializedConfiguration.secrets = secrets = reader.readArray(reader1 -> Secret.fromJson(reader1));
                    continue;
                }
                if ("activeRevisionsMode".equals(fieldName)) {
                    deserializedConfiguration.activeRevisionsMode = ActiveRevisionsMode.fromString(reader.getString());
                    continue;
                }
                if ("ingress".equals(fieldName)) {
                    deserializedConfiguration.ingress = Ingress.fromJson(reader);
                    continue;
                }
                if ("registries".equals(fieldName)) {
                    List registries;
                    deserializedConfiguration.registries = registries = reader.readArray(reader1 -> RegistryCredentials.fromJson(reader1));
                    continue;
                }
                if ("dapr".equals(fieldName)) {
                    deserializedConfiguration.dapr = Dapr.fromJson(reader);
                    continue;
                }
                if ("runtime".equals(fieldName)) {
                    deserializedConfiguration.runtime = Runtime.fromJson(reader);
                    continue;
                }
                if ("maxInactiveRevisions".equals(fieldName)) {
                    deserializedConfiguration.maxInactiveRevisions = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("service".equals(fieldName)) {
                    deserializedConfiguration.service = Service.fromJson(reader);
                    continue;
                }
                if ("identitySettings".equals(fieldName)) {
                    List identitySettings;
                    deserializedConfiguration.identitySettings = identitySettings = reader.readArray(reader1 -> IdentitySettings.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConfiguration;
        });
    }
}

