/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.Applicability;
import java.io.IOException;

public final class AvailableWorkloadProfileProperties
implements JsonSerializable<AvailableWorkloadProfileProperties> {
    private String category;
    private Applicability applicability;
    private Integer cores;
    private Integer memoryGiB;
    private Integer gpus;
    private String displayName;

    public String category() {
        return this.category;
    }

    public AvailableWorkloadProfileProperties withCategory(String category) {
        this.category = category;
        return this;
    }

    public Applicability applicability() {
        return this.applicability;
    }

    public AvailableWorkloadProfileProperties withApplicability(Applicability applicability) {
        this.applicability = applicability;
        return this;
    }

    public Integer cores() {
        return this.cores;
    }

    public AvailableWorkloadProfileProperties withCores(Integer cores) {
        this.cores = cores;
        return this;
    }

    public Integer memoryGiB() {
        return this.memoryGiB;
    }

    public AvailableWorkloadProfileProperties withMemoryGiB(Integer memoryGiB) {
        this.memoryGiB = memoryGiB;
        return this;
    }

    public Integer gpus() {
        return this.gpus;
    }

    public AvailableWorkloadProfileProperties withGpus(Integer gpus) {
        this.gpus = gpus;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public AvailableWorkloadProfileProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("category", this.category);
        jsonWriter.writeStringField("applicability", this.applicability == null ? null : this.applicability.toString());
        jsonWriter.writeNumberField("cores", (Number)this.cores);
        jsonWriter.writeNumberField("memoryGiB", (Number)this.memoryGiB);
        jsonWriter.writeNumberField("gpus", (Number)this.gpus);
        jsonWriter.writeStringField("displayName", this.displayName);
        return jsonWriter.writeEndObject();
    }

    public static AvailableWorkloadProfileProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AvailableWorkloadProfileProperties)jsonReader.readObject(reader -> {
            AvailableWorkloadProfileProperties deserializedAvailableWorkloadProfileProperties = new AvailableWorkloadProfileProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("category".equals(fieldName)) {
                    deserializedAvailableWorkloadProfileProperties.category = reader.getString();
                    continue;
                }
                if ("applicability".equals(fieldName)) {
                    deserializedAvailableWorkloadProfileProperties.applicability = Applicability.fromString(reader.getString());
                    continue;
                }
                if ("cores".equals(fieldName)) {
                    deserializedAvailableWorkloadProfileProperties.cores = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("memoryGiB".equals(fieldName)) {
                    deserializedAvailableWorkloadProfileProperties.memoryGiB = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("gpus".equals(fieldName)) {
                    deserializedAvailableWorkloadProfileProperties.gpus = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedAvailableWorkloadProfileProperties.displayName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAvailableWorkloadProfileProperties;
        });
    }
}

