/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.models.MaintenanceConfigurationResourceInner;
import com.azure.resourcemanager.appcontainers.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appcontainers.models.MaintenanceConfigurationResource;
import com.azure.resourcemanager.appcontainers.models.ScheduledEntry;
import java.util.Collections;
import java.util.List;

public final class MaintenanceConfigurationResourceImpl
implements MaintenanceConfigurationResource,
MaintenanceConfigurationResource.Definition,
MaintenanceConfigurationResource.Update {
    private MaintenanceConfigurationResourceInner innerObject;
    private final ContainerAppsApiManager serviceManager;
    private String resourceGroupName;
    private String environmentName;
    private String configName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public List<ScheduledEntry> scheduledEntries() {
        List<ScheduledEntry> inner = this.innerModel().scheduledEntries();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public MaintenanceConfigurationResourceInner innerModel() {
        return this.innerObject;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    @Override
    public MaintenanceConfigurationResourceImpl withExistingManagedEnvironment(String resourceGroupName, String environmentName) {
        this.resourceGroupName = resourceGroupName;
        this.environmentName = environmentName;
        return this;
    }

    @Override
    public MaintenanceConfigurationResource create() {
        this.innerObject = (MaintenanceConfigurationResourceInner)((Object)this.serviceManager.serviceClient().getMaintenanceConfigurations().createOrUpdateWithResponse(this.resourceGroupName, this.environmentName, this.configName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public MaintenanceConfigurationResource create(Context context) {
        this.innerObject = (MaintenanceConfigurationResourceInner)((Object)this.serviceManager.serviceClient().getMaintenanceConfigurations().createOrUpdateWithResponse(this.resourceGroupName, this.environmentName, this.configName, this.innerModel(), context).getValue());
        return this;
    }

    MaintenanceConfigurationResourceImpl(String name, ContainerAppsApiManager serviceManager) {
        this.innerObject = new MaintenanceConfigurationResourceInner();
        this.serviceManager = serviceManager;
        this.configName = name;
    }

    @Override
    public MaintenanceConfigurationResourceImpl update() {
        return this;
    }

    @Override
    public MaintenanceConfigurationResource apply() {
        this.innerObject = (MaintenanceConfigurationResourceInner)((Object)this.serviceManager.serviceClient().getMaintenanceConfigurations().createOrUpdateWithResponse(this.resourceGroupName, this.environmentName, this.configName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public MaintenanceConfigurationResource apply(Context context) {
        this.innerObject = (MaintenanceConfigurationResourceInner)((Object)this.serviceManager.serviceClient().getMaintenanceConfigurations().createOrUpdateWithResponse(this.resourceGroupName, this.environmentName, this.configName, this.innerModel(), context).getValue());
        return this;
    }

    MaintenanceConfigurationResourceImpl(MaintenanceConfigurationResourceInner innerObject, ContainerAppsApiManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.environmentName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "managedEnvironments");
        this.configName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "maintenanceConfigurations");
    }

    @Override
    public MaintenanceConfigurationResource refresh() {
        this.innerObject = (MaintenanceConfigurationResourceInner)((Object)this.serviceManager.serviceClient().getMaintenanceConfigurations().getWithResponse(this.resourceGroupName, this.environmentName, this.configName, Context.NONE).getValue());
        return this;
    }

    @Override
    public MaintenanceConfigurationResource refresh(Context context) {
        this.innerObject = (MaintenanceConfigurationResourceInner)((Object)this.serviceManager.serviceClient().getMaintenanceConfigurations().getWithResponse(this.resourceGroupName, this.environmentName, this.configName, context).getValue());
        return this;
    }

    @Override
    public MaintenanceConfigurationResourceImpl withScheduledEntries(List<ScheduledEntry> scheduledEntries) {
        this.innerModel().withScheduledEntries(scheduledEntries);
        return this;
    }
}

