/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.LogicAppsClient;
import com.azure.resourcemanager.appcontainers.fluent.models.LogicAppInner;
import com.azure.resourcemanager.appcontainers.fluent.models.WorkflowEnvelopeInner;
import com.azure.resourcemanager.appcontainers.implementation.LogicAppImpl;
import com.azure.resourcemanager.appcontainers.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appcontainers.implementation.WorkflowEnvelopeImpl;
import com.azure.resourcemanager.appcontainers.models.LogicApp;
import com.azure.resourcemanager.appcontainers.models.LogicApps;
import com.azure.resourcemanager.appcontainers.models.WorkflowEnvelope;

public final class LogicAppsImpl
implements LogicApps {
    private static final ClientLogger LOGGER = new ClientLogger(LogicAppsImpl.class);
    private final LogicAppsClient innerClient;
    private final ContainerAppsApiManager serviceManager;

    public LogicAppsImpl(LogicAppsClient innerClient, ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<LogicApp> getWithResponse(String resourceGroupName, String containerAppName, String logicAppName, Context context) {
        Response<LogicAppInner> inner = this.serviceClient().getWithResponse(resourceGroupName, containerAppName, logicAppName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new LogicAppImpl((LogicAppInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public LogicApp get(String resourceGroupName, String containerAppName, String logicAppName) {
        LogicAppInner inner = this.serviceClient().get(resourceGroupName, containerAppName, logicAppName);
        if (inner != null) {
            return new LogicAppImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String containerAppName, String logicAppName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, containerAppName, logicAppName, context);
    }

    @Override
    public void delete(String resourceGroupName, String containerAppName, String logicAppName) {
        this.serviceClient().delete(resourceGroupName, containerAppName, logicAppName);
    }

    @Override
    public PagedIterable<WorkflowEnvelope> listWorkflows(String resourceGroupName, String containerAppName, String logicAppName) {
        PagedIterable<WorkflowEnvelopeInner> inner = this.serviceClient().listWorkflows(resourceGroupName, containerAppName, logicAppName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new WorkflowEnvelopeImpl((WorkflowEnvelopeInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<WorkflowEnvelope> listWorkflows(String resourceGroupName, String containerAppName, String logicAppName, Context context) {
        PagedIterable<WorkflowEnvelopeInner> inner = this.serviceClient().listWorkflows(resourceGroupName, containerAppName, logicAppName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new WorkflowEnvelopeImpl((WorkflowEnvelopeInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<WorkflowEnvelope> getWorkflowWithResponse(String resourceGroupName, String containerAppName, String logicAppName, String workflowName, Context context) {
        Response<WorkflowEnvelopeInner> inner = this.serviceClient().getWorkflowWithResponse(resourceGroupName, containerAppName, logicAppName, workflowName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new WorkflowEnvelopeImpl((WorkflowEnvelopeInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public WorkflowEnvelope getWorkflow(String resourceGroupName, String containerAppName, String logicAppName, String workflowName) {
        WorkflowEnvelopeInner inner = this.serviceClient().getWorkflow(resourceGroupName, containerAppName, logicAppName, workflowName);
        if (inner != null) {
            return new WorkflowEnvelopeImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<WorkflowEnvelope> listWorkflowsConnectionsWithResponse(String resourceGroupName, String containerAppName, String logicAppName, Context context) {
        Response<WorkflowEnvelopeInner> inner = this.serviceClient().listWorkflowsConnectionsWithResponse(resourceGroupName, containerAppName, logicAppName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new WorkflowEnvelopeImpl((WorkflowEnvelopeInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public WorkflowEnvelope listWorkflowsConnections(String resourceGroupName, String containerAppName, String logicAppName) {
        WorkflowEnvelopeInner inner = this.serviceClient().listWorkflowsConnections(resourceGroupName, containerAppName, logicAppName);
        if (inner != null) {
            return new WorkflowEnvelopeImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public LogicApp getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String containerAppName = ResourceManagerUtils.getValueFromIdByName(id, "containerApps");
        if (containerAppName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'containerApps'.", id)));
        }
        String logicAppName = ResourceManagerUtils.getValueFromIdByName(id, "logicApps");
        if (logicAppName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'logicApps'.", id)));
        }
        return (LogicApp)this.getWithResponse(resourceGroupName, containerAppName, logicAppName, Context.NONE).getValue();
    }

    @Override
    public Response<LogicApp> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String containerAppName = ResourceManagerUtils.getValueFromIdByName(id, "containerApps");
        if (containerAppName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'containerApps'.", id)));
        }
        String logicAppName = ResourceManagerUtils.getValueFromIdByName(id, "logicApps");
        if (logicAppName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'logicApps'.", id)));
        }
        return this.getWithResponse(resourceGroupName, containerAppName, logicAppName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String containerAppName = ResourceManagerUtils.getValueFromIdByName(id, "containerApps");
        if (containerAppName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'containerApps'.", id)));
        }
        String logicAppName = ResourceManagerUtils.getValueFromIdByName(id, "logicApps");
        if (logicAppName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'logicApps'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, containerAppName, logicAppName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String containerAppName = ResourceManagerUtils.getValueFromIdByName(id, "containerApps");
        if (containerAppName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'containerApps'.", id)));
        }
        String logicAppName = ResourceManagerUtils.getValueFromIdByName(id, "logicApps");
        if (logicAppName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'logicApps'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, containerAppName, logicAppName, context);
    }

    private LogicAppsClient serviceClient() {
        return this.innerClient;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    @Override
    public LogicAppImpl define(String name) {
        return new LogicAppImpl(name, this.manager());
    }
}

