/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.models.JavaComponentInner;
import com.azure.resourcemanager.appcontainers.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appcontainers.models.JavaComponent;
import com.azure.resourcemanager.appcontainers.models.JavaComponentProperties;

public final class JavaComponentImpl
implements JavaComponent,
JavaComponent.Definition,
JavaComponent.Update {
    private JavaComponentInner innerObject;
    private final ContainerAppsApiManager serviceManager;
    private String resourceGroupName;
    private String environmentName;
    private String name;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public JavaComponentProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public JavaComponentInner innerModel() {
        return this.innerObject;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    @Override
    public JavaComponentImpl withExistingManagedEnvironment(String resourceGroupName, String environmentName) {
        this.resourceGroupName = resourceGroupName;
        this.environmentName = environmentName;
        return this;
    }

    @Override
    public JavaComponent create() {
        this.innerObject = this.serviceManager.serviceClient().getJavaComponents().createOrUpdate(this.resourceGroupName, this.environmentName, this.name, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public JavaComponent create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getJavaComponents().createOrUpdate(this.resourceGroupName, this.environmentName, this.name, this.innerModel(), context);
        return this;
    }

    JavaComponentImpl(String name, ContainerAppsApiManager serviceManager) {
        this.innerObject = new JavaComponentInner();
        this.serviceManager = serviceManager;
        this.name = name;
    }

    @Override
    public JavaComponentImpl update() {
        return this;
    }

    @Override
    public JavaComponent apply() {
        this.innerObject = this.serviceManager.serviceClient().getJavaComponents().update(this.resourceGroupName, this.environmentName, this.name, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public JavaComponent apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getJavaComponents().update(this.resourceGroupName, this.environmentName, this.name, this.innerModel(), context);
        return this;
    }

    JavaComponentImpl(JavaComponentInner innerObject, ContainerAppsApiManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.environmentName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "managedEnvironments");
        this.name = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "javaComponents");
    }

    @Override
    public JavaComponent refresh() {
        this.innerObject = (JavaComponentInner)((Object)this.serviceManager.serviceClient().getJavaComponents().getWithResponse(this.resourceGroupName, this.environmentName, this.name, Context.NONE).getValue());
        return this;
    }

    @Override
    public JavaComponent refresh(Context context) {
        this.innerObject = (JavaComponentInner)((Object)this.serviceManager.serviceClient().getJavaComponents().getWithResponse(this.resourceGroupName, this.environmentName, this.name, context).getValue());
        return this;
    }

    @Override
    public JavaComponentImpl withProperties(JavaComponentProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

