/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.appcontainers.fluent.ConnectedEnvironmentsStoragesClient;
import com.azure.resourcemanager.appcontainers.fluent.models.ConnectedEnvironmentStorageInner;
import com.azure.resourcemanager.appcontainers.fluent.models.ConnectedEnvironmentStoragesCollectionInner;
import com.azure.resourcemanager.appcontainers.implementation.ContainerAppsApiClientImpl;
import com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ConnectedEnvironmentsStoragesClientImpl
implements ConnectedEnvironmentsStoragesClient {
    private final ConnectedEnvironmentsStoragesService service;
    private final ContainerAppsApiClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(ConnectedEnvironmentsStoragesClientImpl.class);

    ConnectedEnvironmentsStoragesClientImpl(ContainerAppsApiClientImpl client) {
        this.service = (ConnectedEnvironmentsStoragesService)RestProxy.create(ConnectedEnvironmentsStoragesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ConnectedEnvironmentStoragesCollectionInner>> listWithResponseAsync(String resourceGroupName, String connectedEnvironmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, connectedEnvironmentName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ConnectedEnvironmentStoragesCollectionInner> listAsync(String resourceGroupName, String connectedEnvironmentName) {
        return this.listWithResponseAsync(resourceGroupName, connectedEnvironmentName).flatMap(res -> Mono.justOrEmpty((Object)((ConnectedEnvironmentStoragesCollectionInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ConnectedEnvironmentStoragesCollectionInner> listWithResponse(String resourceGroupName, String connectedEnvironmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.listSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, connectedEnvironmentName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConnectedEnvironmentStoragesCollectionInner list(String resourceGroupName, String connectedEnvironmentName) {
        return (ConnectedEnvironmentStoragesCollectionInner)this.listWithResponse(resourceGroupName, connectedEnvironmentName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ConnectedEnvironmentStorageInner>> getWithResponseAsync(String resourceGroupName, String connectedEnvironmentName, String storageName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        if (storageName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter storageName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, connectedEnvironmentName, storageName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ConnectedEnvironmentStorageInner> getAsync(String resourceGroupName, String connectedEnvironmentName, String storageName) {
        return this.getWithResponseAsync(resourceGroupName, connectedEnvironmentName, storageName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ConnectedEnvironmentStorageInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ConnectedEnvironmentStorageInner> getWithResponse(String resourceGroupName, String connectedEnvironmentName, String storageName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        if (storageName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter storageName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, connectedEnvironmentName, storageName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConnectedEnvironmentStorageInner get(String resourceGroupName, String connectedEnvironmentName, String storageName) {
        return (ConnectedEnvironmentStorageInner)((Object)this.getWithResponse(resourceGroupName, connectedEnvironmentName, storageName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String connectedEnvironmentName, String storageName, ConnectedEnvironmentStorageInner storageEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        if (storageName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter storageName is required and cannot be null."));
        }
        if (storageEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter storageEnvelope is required and cannot be null."));
        }
        storageEnvelope.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, connectedEnvironmentName, storageName, this.client.getApiVersion(), storageEnvelope, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String connectedEnvironmentName, String storageName, ConnectedEnvironmentStorageInner storageEnvelope) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        if (storageName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter storageName is required and cannot be null."));
        }
        if (storageEnvelope == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter storageEnvelope is required and cannot be null."));
        }
        storageEnvelope.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, connectedEnvironmentName, storageName, this.client.getApiVersion(), storageEnvelope, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String connectedEnvironmentName, String storageName, ConnectedEnvironmentStorageInner storageEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        if (storageName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter storageName is required and cannot be null."));
        }
        if (storageEnvelope == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter storageEnvelope is required and cannot be null."));
        }
        storageEnvelope.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, connectedEnvironmentName, storageName, this.client.getApiVersion(), storageEnvelope, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ConnectedEnvironmentStorageInner>, ConnectedEnvironmentStorageInner> beginCreateOrUpdateAsync(String resourceGroupName, String connectedEnvironmentName, String storageName, ConnectedEnvironmentStorageInner storageEnvelope) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, connectedEnvironmentName, storageName, storageEnvelope);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ConnectedEnvironmentStorageInner.class), (Type)((Object)ConnectedEnvironmentStorageInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ConnectedEnvironmentStorageInner>, ConnectedEnvironmentStorageInner> beginCreateOrUpdate(String resourceGroupName, String connectedEnvironmentName, String storageName, ConnectedEnvironmentStorageInner storageEnvelope) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, connectedEnvironmentName, storageName, storageEnvelope);
        return this.client.getLroResult(response, (Type)((Object)ConnectedEnvironmentStorageInner.class), (Type)((Object)ConnectedEnvironmentStorageInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ConnectedEnvironmentStorageInner>, ConnectedEnvironmentStorageInner> beginCreateOrUpdate(String resourceGroupName, String connectedEnvironmentName, String storageName, ConnectedEnvironmentStorageInner storageEnvelope, Context context) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, connectedEnvironmentName, storageName, storageEnvelope, context);
        return this.client.getLroResult(response, (Type)((Object)ConnectedEnvironmentStorageInner.class), (Type)((Object)ConnectedEnvironmentStorageInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ConnectedEnvironmentStorageInner> createOrUpdateAsync(String resourceGroupName, String connectedEnvironmentName, String storageName, ConnectedEnvironmentStorageInner storageEnvelope) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, connectedEnvironmentName, storageName, storageEnvelope).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConnectedEnvironmentStorageInner createOrUpdate(String resourceGroupName, String connectedEnvironmentName, String storageName, ConnectedEnvironmentStorageInner storageEnvelope) {
        return (ConnectedEnvironmentStorageInner)((Object)this.beginCreateOrUpdate(resourceGroupName, connectedEnvironmentName, storageName, storageEnvelope).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConnectedEnvironmentStorageInner createOrUpdate(String resourceGroupName, String connectedEnvironmentName, String storageName, ConnectedEnvironmentStorageInner storageEnvelope, Context context) {
        return (ConnectedEnvironmentStorageInner)((Object)this.beginCreateOrUpdate(resourceGroupName, connectedEnvironmentName, storageName, storageEnvelope, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String connectedEnvironmentName, String storageName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        if (storageName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter storageName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, connectedEnvironmentName, storageName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String connectedEnvironmentName, String storageName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        if (storageName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter storageName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, connectedEnvironmentName, storageName, this.client.getApiVersion(), "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String connectedEnvironmentName, String storageName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        if (storageName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter storageName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, connectedEnvironmentName, storageName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String connectedEnvironmentName, String storageName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, connectedEnvironmentName, storageName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String connectedEnvironmentName, String storageName) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, connectedEnvironmentName, storageName);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String connectedEnvironmentName, String storageName, Context context) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, connectedEnvironmentName, storageName, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String connectedEnvironmentName, String storageName) {
        return this.beginDeleteAsync(resourceGroupName, connectedEnvironmentName, storageName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String connectedEnvironmentName, String storageName) {
        this.beginDelete(resourceGroupName, connectedEnvironmentName, storageName).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String connectedEnvironmentName, String storageName, Context context) {
        this.beginDelete(resourceGroupName, connectedEnvironmentName, storageName, context).getFinalResult();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ContainerAppsApiClientConnectedEnvironmentsStorages")
    public static interface ConnectedEnvironmentsStoragesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/connectedEnvironments/{connectedEnvironmentName}/storages")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<ConnectedEnvironmentStoragesCollectionInner>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="connectedEnvironmentName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/connectedEnvironments/{connectedEnvironmentName}/storages")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Response<ConnectedEnvironmentStoragesCollectionInner> listSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="connectedEnvironmentName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/connectedEnvironments/{connectedEnvironmentName}/storages/{storageName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<ConnectedEnvironmentStorageInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="connectedEnvironmentName") String var4, @PathParam(value="storageName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/connectedEnvironments/{connectedEnvironmentName}/storages/{storageName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Response<ConnectedEnvironmentStorageInner> getSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="connectedEnvironmentName") String var4, @PathParam(value="storageName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/connectedEnvironments/{connectedEnvironmentName}/storages/{storageName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="connectedEnvironmentName") String var4, @PathParam(value="storageName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") ConnectedEnvironmentStorageInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/connectedEnvironments/{connectedEnvironmentName}/storages/{storageName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> createOrUpdateSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="connectedEnvironmentName") String var4, @PathParam(value="storageName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") ConnectedEnvironmentStorageInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/connectedEnvironments/{connectedEnvironmentName}/storages/{storageName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="connectedEnvironmentName") String var4, @PathParam(value="storageName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/connectedEnvironments/{connectedEnvironmentName}/storages/{storageName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> deleteSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="connectedEnvironmentName") String var4, @PathParam(value="storageName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

