/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.WorkflowEnvelopeProperties;
import com.azure.resourcemanager.appcontainers.models.WorkflowKind;
import java.io.IOException;

public final class WorkflowEnvelopeInner
extends ProxyResource {
    private WorkflowKind kind;
    private WorkflowEnvelopeProperties properties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public WorkflowKind kind() {
        return this.kind;
    }

    public WorkflowEnvelopeInner withKind(WorkflowKind kind) {
        this.kind = kind;
        return this;
    }

    public WorkflowEnvelopeProperties properties() {
        return this.properties;
    }

    public WorkflowEnvelopeInner withProperties(WorkflowEnvelopeProperties properties) {
        this.properties = properties;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static WorkflowEnvelopeInner fromJson(JsonReader jsonReader) throws IOException {
        return (WorkflowEnvelopeInner)((Object)jsonReader.readObject(reader -> {
            WorkflowEnvelopeInner deserializedWorkflowEnvelopeInner = new WorkflowEnvelopeInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedWorkflowEnvelopeInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedWorkflowEnvelopeInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedWorkflowEnvelopeInner.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedWorkflowEnvelopeInner.kind = WorkflowKind.fromString(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedWorkflowEnvelopeInner.properties = WorkflowEnvelopeProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedWorkflowEnvelopeInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkflowEnvelopeInner;
        }));
    }
}

