/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.appcontainers.models.AppLogsConfiguration;
import com.azure.resourcemanager.appcontainers.models.CustomDomainConfiguration;
import com.azure.resourcemanager.appcontainers.models.DaprConfiguration;
import com.azure.resourcemanager.appcontainers.models.EnvironmentProvisioningState;
import com.azure.resourcemanager.appcontainers.models.IngressConfiguration;
import com.azure.resourcemanager.appcontainers.models.KedaConfiguration;
import com.azure.resourcemanager.appcontainers.models.ManagedEnvironmentPropertiesPeerAuthentication;
import com.azure.resourcemanager.appcontainers.models.ManagedEnvironmentPropertiesPeerTrafficConfiguration;
import com.azure.resourcemanager.appcontainers.models.PublicNetworkAccess;
import com.azure.resourcemanager.appcontainers.models.VnetConfiguration;
import com.azure.resourcemanager.appcontainers.models.WorkloadProfile;
import java.io.IOException;
import java.util.List;

public final class ManagedEnvironmentProperties
implements JsonSerializable<ManagedEnvironmentProperties> {
    private EnvironmentProvisioningState provisioningState;
    private String daprAIInstrumentationKey;
    private String daprAIConnectionString;
    private VnetConfiguration vnetConfiguration;
    private String deploymentErrors;
    private String defaultDomain;
    private String staticIp;
    private AppLogsConfiguration appLogsConfiguration;
    private Boolean zoneRedundant;
    private CustomDomainConfiguration customDomainConfiguration;
    private String eventStreamEndpoint;
    private List<WorkloadProfile> workloadProfiles;
    private KedaConfiguration kedaConfiguration;
    private DaprConfiguration daprConfiguration;
    private String infrastructureResourceGroup;
    private ManagedEnvironmentPropertiesPeerAuthentication peerAuthentication;
    private ManagedEnvironmentPropertiesPeerTrafficConfiguration peerTrafficConfiguration;
    private IngressConfiguration ingressConfiguration;
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;
    private PublicNetworkAccess publicNetworkAccess;

    public EnvironmentProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String daprAIInstrumentationKey() {
        return this.daprAIInstrumentationKey;
    }

    public ManagedEnvironmentProperties withDaprAIInstrumentationKey(String daprAIInstrumentationKey) {
        this.daprAIInstrumentationKey = daprAIInstrumentationKey;
        return this;
    }

    public String daprAIConnectionString() {
        return this.daprAIConnectionString;
    }

    public ManagedEnvironmentProperties withDaprAIConnectionString(String daprAIConnectionString) {
        this.daprAIConnectionString = daprAIConnectionString;
        return this;
    }

    public VnetConfiguration vnetConfiguration() {
        return this.vnetConfiguration;
    }

    public ManagedEnvironmentProperties withVnetConfiguration(VnetConfiguration vnetConfiguration) {
        this.vnetConfiguration = vnetConfiguration;
        return this;
    }

    public String deploymentErrors() {
        return this.deploymentErrors;
    }

    public String defaultDomain() {
        return this.defaultDomain;
    }

    public String staticIp() {
        return this.staticIp;
    }

    public AppLogsConfiguration appLogsConfiguration() {
        return this.appLogsConfiguration;
    }

    public ManagedEnvironmentProperties withAppLogsConfiguration(AppLogsConfiguration appLogsConfiguration) {
        this.appLogsConfiguration = appLogsConfiguration;
        return this;
    }

    public Boolean zoneRedundant() {
        return this.zoneRedundant;
    }

    public ManagedEnvironmentProperties withZoneRedundant(Boolean zoneRedundant) {
        this.zoneRedundant = zoneRedundant;
        return this;
    }

    public CustomDomainConfiguration customDomainConfiguration() {
        return this.customDomainConfiguration;
    }

    public ManagedEnvironmentProperties withCustomDomainConfiguration(CustomDomainConfiguration customDomainConfiguration) {
        this.customDomainConfiguration = customDomainConfiguration;
        return this;
    }

    public String eventStreamEndpoint() {
        return this.eventStreamEndpoint;
    }

    public List<WorkloadProfile> workloadProfiles() {
        return this.workloadProfiles;
    }

    public ManagedEnvironmentProperties withWorkloadProfiles(List<WorkloadProfile> workloadProfiles) {
        this.workloadProfiles = workloadProfiles;
        return this;
    }

    public KedaConfiguration kedaConfiguration() {
        return this.kedaConfiguration;
    }

    public ManagedEnvironmentProperties withKedaConfiguration(KedaConfiguration kedaConfiguration) {
        this.kedaConfiguration = kedaConfiguration;
        return this;
    }

    public DaprConfiguration daprConfiguration() {
        return this.daprConfiguration;
    }

    public ManagedEnvironmentProperties withDaprConfiguration(DaprConfiguration daprConfiguration) {
        this.daprConfiguration = daprConfiguration;
        return this;
    }

    public String infrastructureResourceGroup() {
        return this.infrastructureResourceGroup;
    }

    public ManagedEnvironmentProperties withInfrastructureResourceGroup(String infrastructureResourceGroup) {
        this.infrastructureResourceGroup = infrastructureResourceGroup;
        return this;
    }

    public ManagedEnvironmentPropertiesPeerAuthentication peerAuthentication() {
        return this.peerAuthentication;
    }

    public ManagedEnvironmentProperties withPeerAuthentication(ManagedEnvironmentPropertiesPeerAuthentication peerAuthentication) {
        this.peerAuthentication = peerAuthentication;
        return this;
    }

    public ManagedEnvironmentPropertiesPeerTrafficConfiguration peerTrafficConfiguration() {
        return this.peerTrafficConfiguration;
    }

    public ManagedEnvironmentProperties withPeerTrafficConfiguration(ManagedEnvironmentPropertiesPeerTrafficConfiguration peerTrafficConfiguration) {
        this.peerTrafficConfiguration = peerTrafficConfiguration;
        return this;
    }

    public IngressConfiguration ingressConfiguration() {
        return this.ingressConfiguration;
    }

    public ManagedEnvironmentProperties withIngressConfiguration(IngressConfiguration ingressConfiguration) {
        this.ingressConfiguration = ingressConfiguration;
        return this;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public ManagedEnvironmentProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public void validate() {
        if (this.vnetConfiguration() != null) {
            this.vnetConfiguration().validate();
        }
        if (this.appLogsConfiguration() != null) {
            this.appLogsConfiguration().validate();
        }
        if (this.customDomainConfiguration() != null) {
            this.customDomainConfiguration().validate();
        }
        if (this.workloadProfiles() != null) {
            this.workloadProfiles().forEach(e -> e.validate());
        }
        if (this.kedaConfiguration() != null) {
            this.kedaConfiguration().validate();
        }
        if (this.daprConfiguration() != null) {
            this.daprConfiguration().validate();
        }
        if (this.peerAuthentication() != null) {
            this.peerAuthentication().validate();
        }
        if (this.peerTrafficConfiguration() != null) {
            this.peerTrafficConfiguration().validate();
        }
        if (this.ingressConfiguration() != null) {
            this.ingressConfiguration().validate();
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("daprAIInstrumentationKey", this.daprAIInstrumentationKey);
        jsonWriter.writeStringField("daprAIConnectionString", this.daprAIConnectionString);
        jsonWriter.writeJsonField("vnetConfiguration", (JsonSerializable)this.vnetConfiguration);
        jsonWriter.writeJsonField("appLogsConfiguration", (JsonSerializable)this.appLogsConfiguration);
        jsonWriter.writeBooleanField("zoneRedundant", this.zoneRedundant);
        jsonWriter.writeJsonField("customDomainConfiguration", (JsonSerializable)this.customDomainConfiguration);
        jsonWriter.writeArrayField("workloadProfiles", this.workloadProfiles, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("kedaConfiguration", (JsonSerializable)this.kedaConfiguration);
        jsonWriter.writeJsonField("daprConfiguration", (JsonSerializable)this.daprConfiguration);
        jsonWriter.writeStringField("infrastructureResourceGroup", this.infrastructureResourceGroup);
        jsonWriter.writeJsonField("peerAuthentication", (JsonSerializable)this.peerAuthentication);
        jsonWriter.writeJsonField("peerTrafficConfiguration", (JsonSerializable)this.peerTrafficConfiguration);
        jsonWriter.writeJsonField("ingressConfiguration", (JsonSerializable)this.ingressConfiguration);
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        return jsonWriter.writeEndObject();
    }

    public static ManagedEnvironmentProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedEnvironmentProperties)jsonReader.readObject(reader -> {
            ManagedEnvironmentProperties deserializedManagedEnvironmentProperties = new ManagedEnvironmentProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedManagedEnvironmentProperties.provisioningState = EnvironmentProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("daprAIInstrumentationKey".equals(fieldName)) {
                    deserializedManagedEnvironmentProperties.daprAIInstrumentationKey = reader.getString();
                    continue;
                }
                if ("daprAIConnectionString".equals(fieldName)) {
                    deserializedManagedEnvironmentProperties.daprAIConnectionString = reader.getString();
                    continue;
                }
                if ("vnetConfiguration".equals(fieldName)) {
                    deserializedManagedEnvironmentProperties.vnetConfiguration = VnetConfiguration.fromJson(reader);
                    continue;
                }
                if ("deploymentErrors".equals(fieldName)) {
                    deserializedManagedEnvironmentProperties.deploymentErrors = reader.getString();
                    continue;
                }
                if ("defaultDomain".equals(fieldName)) {
                    deserializedManagedEnvironmentProperties.defaultDomain = reader.getString();
                    continue;
                }
                if ("staticIp".equals(fieldName)) {
                    deserializedManagedEnvironmentProperties.staticIp = reader.getString();
                    continue;
                }
                if ("appLogsConfiguration".equals(fieldName)) {
                    deserializedManagedEnvironmentProperties.appLogsConfiguration = AppLogsConfiguration.fromJson(reader);
                    continue;
                }
                if ("zoneRedundant".equals(fieldName)) {
                    deserializedManagedEnvironmentProperties.zoneRedundant = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("customDomainConfiguration".equals(fieldName)) {
                    deserializedManagedEnvironmentProperties.customDomainConfiguration = CustomDomainConfiguration.fromJson(reader);
                    continue;
                }
                if ("eventStreamEndpoint".equals(fieldName)) {
                    deserializedManagedEnvironmentProperties.eventStreamEndpoint = reader.getString();
                    continue;
                }
                if ("workloadProfiles".equals(fieldName)) {
                    List workloadProfiles;
                    deserializedManagedEnvironmentProperties.workloadProfiles = workloadProfiles = reader.readArray(reader1 -> WorkloadProfile.fromJson(reader1));
                    continue;
                }
                if ("kedaConfiguration".equals(fieldName)) {
                    deserializedManagedEnvironmentProperties.kedaConfiguration = KedaConfiguration.fromJson(reader);
                    continue;
                }
                if ("daprConfiguration".equals(fieldName)) {
                    deserializedManagedEnvironmentProperties.daprConfiguration = DaprConfiguration.fromJson(reader);
                    continue;
                }
                if ("infrastructureResourceGroup".equals(fieldName)) {
                    deserializedManagedEnvironmentProperties.infrastructureResourceGroup = reader.getString();
                    continue;
                }
                if ("peerAuthentication".equals(fieldName)) {
                    deserializedManagedEnvironmentProperties.peerAuthentication = ManagedEnvironmentPropertiesPeerAuthentication.fromJson(reader);
                    continue;
                }
                if ("peerTrafficConfiguration".equals(fieldName)) {
                    deserializedManagedEnvironmentProperties.peerTrafficConfiguration = ManagedEnvironmentPropertiesPeerTrafficConfiguration.fromJson(reader);
                    continue;
                }
                if ("ingressConfiguration".equals(fieldName)) {
                    deserializedManagedEnvironmentProperties.ingressConfiguration = IngressConfiguration.fromJson(reader);
                    continue;
                }
                if ("privateEndpointConnections".equals(fieldName)) {
                    List privateEndpointConnections;
                    deserializedManagedEnvironmentProperties.privateEndpointConnections = privateEndpointConnections = reader.readArray(reader1 -> PrivateEndpointConnectionInner.fromJson(reader1));
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedManagedEnvironmentProperties.publicNetworkAccess = PublicNetworkAccess.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedEnvironmentProperties;
        });
    }
}

