/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.fluent.models.ScheduledEntries;
import com.azure.resourcemanager.appcontainers.models.ScheduledEntry;
import java.io.IOException;
import java.util.List;

public final class MaintenanceConfigurationResourceInner
extends ProxyResource {
    private ScheduledEntries innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private ScheduledEntries innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public List<ScheduledEntry> scheduledEntries() {
        return this.innerProperties() == null ? null : this.innerProperties().scheduledEntries();
    }

    public MaintenanceConfigurationResourceInner withScheduledEntries(List<ScheduledEntry> scheduledEntries) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledEntries();
        }
        this.innerProperties().withScheduledEntries(scheduledEntries);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static MaintenanceConfigurationResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (MaintenanceConfigurationResourceInner)((Object)jsonReader.readObject(reader -> {
            MaintenanceConfigurationResourceInner deserializedMaintenanceConfigurationResourceInner = new MaintenanceConfigurationResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMaintenanceConfigurationResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedMaintenanceConfigurationResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMaintenanceConfigurationResourceInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedMaintenanceConfigurationResourceInner.innerProperties = ScheduledEntries.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedMaintenanceConfigurationResourceInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMaintenanceConfigurationResourceInner;
        }));
    }
}

