/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.SecretVolumeItem;
import com.azure.resourcemanager.appcontainers.models.StorageType;
import java.io.IOException;
import java.util.List;

public final class Volume
implements JsonSerializable<Volume> {
    private String name;
    private StorageType storageType;
    private String storageName;
    private List<SecretVolumeItem> secrets;
    private String mountOptions;

    public String name() {
        return this.name;
    }

    public Volume withName(String name) {
        this.name = name;
        return this;
    }

    public StorageType storageType() {
        return this.storageType;
    }

    public Volume withStorageType(StorageType storageType) {
        this.storageType = storageType;
        return this;
    }

    public String storageName() {
        return this.storageName;
    }

    public Volume withStorageName(String storageName) {
        this.storageName = storageName;
        return this;
    }

    public List<SecretVolumeItem> secrets() {
        return this.secrets;
    }

    public Volume withSecrets(List<SecretVolumeItem> secrets) {
        this.secrets = secrets;
        return this;
    }

    public String mountOptions() {
        return this.mountOptions;
    }

    public Volume withMountOptions(String mountOptions) {
        this.mountOptions = mountOptions;
        return this;
    }

    public void validate() {
        if (this.secrets() != null) {
            this.secrets().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("storageType", this.storageType == null ? null : this.storageType.toString());
        jsonWriter.writeStringField("storageName", this.storageName);
        jsonWriter.writeArrayField("secrets", this.secrets, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("mountOptions", this.mountOptions);
        return jsonWriter.writeEndObject();
    }

    public static Volume fromJson(JsonReader jsonReader) throws IOException {
        return (Volume)jsonReader.readObject(reader -> {
            Volume deserializedVolume = new Volume();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedVolume.name = reader.getString();
                    continue;
                }
                if ("storageType".equals(fieldName)) {
                    deserializedVolume.storageType = StorageType.fromString(reader.getString());
                    continue;
                }
                if ("storageName".equals(fieldName)) {
                    deserializedVolume.storageName = reader.getString();
                    continue;
                }
                if ("secrets".equals(fieldName)) {
                    List secrets;
                    deserializedVolume.secrets = secrets = reader.readArray(reader1 -> SecretVolumeItem.fromJson(reader1));
                    continue;
                }
                if ("mountOptions".equals(fieldName)) {
                    deserializedVolume.mountOptions = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVolume;
        });
    }
}

