/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.JavaComponentConfigurationProperty;
import com.azure.resourcemanager.appcontainers.models.JavaComponentIngress;
import com.azure.resourcemanager.appcontainers.models.JavaComponentProperties;
import com.azure.resourcemanager.appcontainers.models.JavaComponentPropertiesScale;
import com.azure.resourcemanager.appcontainers.models.JavaComponentProvisioningState;
import com.azure.resourcemanager.appcontainers.models.JavaComponentServiceBind;
import com.azure.resourcemanager.appcontainers.models.JavaComponentType;
import com.azure.resourcemanager.appcontainers.models.ScgRoute;
import java.io.IOException;
import java.util.List;

public final class SpringCloudGatewayComponent
extends JavaComponentProperties {
    private JavaComponentType componentType = JavaComponentType.SPRING_CLOUD_GATEWAY;
    private JavaComponentIngress ingress;
    private List<ScgRoute> springCloudGatewayRoutes;

    @Override
    public JavaComponentType componentType() {
        return this.componentType;
    }

    public JavaComponentIngress ingress() {
        return this.ingress;
    }

    public SpringCloudGatewayComponent withIngress(JavaComponentIngress ingress) {
        this.ingress = ingress;
        return this;
    }

    public List<ScgRoute> springCloudGatewayRoutes() {
        return this.springCloudGatewayRoutes;
    }

    public SpringCloudGatewayComponent withSpringCloudGatewayRoutes(List<ScgRoute> springCloudGatewayRoutes) {
        this.springCloudGatewayRoutes = springCloudGatewayRoutes;
        return this;
    }

    @Override
    public SpringCloudGatewayComponent withConfigurations(List<JavaComponentConfigurationProperty> configurations) {
        super.withConfigurations(configurations);
        return this;
    }

    @Override
    public SpringCloudGatewayComponent withScale(JavaComponentPropertiesScale scale) {
        super.withScale(scale);
        return this;
    }

    @Override
    public SpringCloudGatewayComponent withServiceBinds(List<JavaComponentServiceBind> serviceBinds) {
        super.withServiceBinds(serviceBinds);
        return this;
    }

    @Override
    public void validate() {
        if (this.ingress() != null) {
            this.ingress().validate();
        }
        if (this.springCloudGatewayRoutes() != null) {
            this.springCloudGatewayRoutes().forEach(e -> e.validate());
        }
        if (this.configurations() != null) {
            this.configurations().forEach(e -> e.validate());
        }
        if (this.scale() != null) {
            this.scale().validate();
        }
        if (this.serviceBinds() != null) {
            this.serviceBinds().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("configurations", this.configurations(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("scale", (JsonSerializable)this.scale());
        jsonWriter.writeArrayField("serviceBinds", this.serviceBinds(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("componentType", this.componentType == null ? null : this.componentType.toString());
        jsonWriter.writeJsonField("ingress", (JsonSerializable)this.ingress);
        jsonWriter.writeArrayField("springCloudGatewayRoutes", this.springCloudGatewayRoutes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SpringCloudGatewayComponent fromJson(JsonReader jsonReader) throws IOException {
        return (SpringCloudGatewayComponent)jsonReader.readObject(reader -> {
            SpringCloudGatewayComponent deserializedSpringCloudGatewayComponent = new SpringCloudGatewayComponent();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedSpringCloudGatewayComponent.withProvisioningState(JavaComponentProvisioningState.fromString(reader.getString()));
                    continue;
                }
                if ("configurations".equals(fieldName)) {
                    List configurations = reader.readArray(reader1 -> JavaComponentConfigurationProperty.fromJson(reader1));
                    deserializedSpringCloudGatewayComponent.withConfigurations(configurations);
                    continue;
                }
                if ("scale".equals(fieldName)) {
                    deserializedSpringCloudGatewayComponent.withScale(JavaComponentPropertiesScale.fromJson(reader));
                    continue;
                }
                if ("serviceBinds".equals(fieldName)) {
                    List serviceBinds = reader.readArray(reader1 -> JavaComponentServiceBind.fromJson(reader1));
                    deserializedSpringCloudGatewayComponent.withServiceBinds(serviceBinds);
                    continue;
                }
                if ("componentType".equals(fieldName)) {
                    deserializedSpringCloudGatewayComponent.componentType = JavaComponentType.fromString(reader.getString());
                    continue;
                }
                if ("ingress".equals(fieldName)) {
                    deserializedSpringCloudGatewayComponent.ingress = JavaComponentIngress.fromJson(reader);
                    continue;
                }
                if ("springCloudGatewayRoutes".equals(fieldName)) {
                    List springCloudGatewayRoutes;
                    deserializedSpringCloudGatewayComponent.springCloudGatewayRoutes = springCloudGatewayRoutes = reader.readArray(reader1 -> ScgRoute.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSpringCloudGatewayComponent;
        });
    }
}

