/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.AccessMode;
import java.io.IOException;

public final class SmbStorage
implements JsonSerializable<SmbStorage> {
    private String host;
    private String shareName;
    private String username;
    private String domain;
    private String password;
    private AccessMode accessMode;

    public String host() {
        return this.host;
    }

    public SmbStorage withHost(String host) {
        this.host = host;
        return this;
    }

    public String shareName() {
        return this.shareName;
    }

    public SmbStorage withShareName(String shareName) {
        this.shareName = shareName;
        return this;
    }

    public String username() {
        return this.username;
    }

    public SmbStorage withUsername(String username) {
        this.username = username;
        return this;
    }

    public String domain() {
        return this.domain;
    }

    public SmbStorage withDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public String password() {
        return this.password;
    }

    public SmbStorage withPassword(String password) {
        this.password = password;
        return this;
    }

    public AccessMode accessMode() {
        return this.accessMode;
    }

    public SmbStorage withAccessMode(AccessMode accessMode) {
        this.accessMode = accessMode;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("host", this.host);
        jsonWriter.writeStringField("shareName", this.shareName);
        jsonWriter.writeStringField("username", this.username);
        jsonWriter.writeStringField("domain", this.domain);
        jsonWriter.writeStringField("password", this.password);
        jsonWriter.writeStringField("accessMode", this.accessMode == null ? null : this.accessMode.toString());
        return jsonWriter.writeEndObject();
    }

    public static SmbStorage fromJson(JsonReader jsonReader) throws IOException {
        return (SmbStorage)jsonReader.readObject(reader -> {
            SmbStorage deserializedSmbStorage = new SmbStorage();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("host".equals(fieldName)) {
                    deserializedSmbStorage.host = reader.getString();
                    continue;
                }
                if ("shareName".equals(fieldName)) {
                    deserializedSmbStorage.shareName = reader.getString();
                    continue;
                }
                if ("username".equals(fieldName)) {
                    deserializedSmbStorage.username = reader.getString();
                    continue;
                }
                if ("domain".equals(fieldName)) {
                    deserializedSmbStorage.domain = reader.getString();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedSmbStorage.password = reader.getString();
                    continue;
                }
                if ("accessMode".equals(fieldName)) {
                    deserializedSmbStorage.accessMode = AccessMode.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSmbStorage;
        });
    }
}

