/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.Scheme;
import com.azure.resourcemanager.appcontainers.models.SessionProbeHttpGetHttpHeadersItem;
import java.io.IOException;
import java.util.List;

public final class SessionProbeHttpGet
implements JsonSerializable<SessionProbeHttpGet> {
    private String host;
    private List<SessionProbeHttpGetHttpHeadersItem> httpHeaders;
    private String path;
    private int port;
    private Scheme scheme;

    public String host() {
        return this.host;
    }

    public SessionProbeHttpGet withHost(String host) {
        this.host = host;
        return this;
    }

    public List<SessionProbeHttpGetHttpHeadersItem> httpHeaders() {
        return this.httpHeaders;
    }

    public SessionProbeHttpGet withHttpHeaders(List<SessionProbeHttpGetHttpHeadersItem> httpHeaders) {
        this.httpHeaders = httpHeaders;
        return this;
    }

    public String path() {
        return this.path;
    }

    public SessionProbeHttpGet withPath(String path) {
        this.path = path;
        return this;
    }

    public int port() {
        return this.port;
    }

    public SessionProbeHttpGet withPort(int port) {
        this.port = port;
        return this;
    }

    public Scheme scheme() {
        return this.scheme;
    }

    public SessionProbeHttpGet withScheme(Scheme scheme) {
        this.scheme = scheme;
        return this;
    }

    public void validate() {
        if (this.httpHeaders() != null) {
            this.httpHeaders().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("port", this.port);
        jsonWriter.writeStringField("host", this.host);
        jsonWriter.writeArrayField("httpHeaders", this.httpHeaders, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("path", this.path);
        jsonWriter.writeStringField("scheme", this.scheme == null ? null : this.scheme.toString());
        return jsonWriter.writeEndObject();
    }

    public static SessionProbeHttpGet fromJson(JsonReader jsonReader) throws IOException {
        return (SessionProbeHttpGet)jsonReader.readObject(reader -> {
            SessionProbeHttpGet deserializedSessionProbeHttpGet = new SessionProbeHttpGet();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("port".equals(fieldName)) {
                    deserializedSessionProbeHttpGet.port = reader.getInt();
                    continue;
                }
                if ("host".equals(fieldName)) {
                    deserializedSessionProbeHttpGet.host = reader.getString();
                    continue;
                }
                if ("httpHeaders".equals(fieldName)) {
                    List httpHeaders;
                    deserializedSessionProbeHttpGet.httpHeaders = httpHeaders = reader.readArray(reader1 -> SessionProbeHttpGetHttpHeadersItem.fromJson(reader1));
                    continue;
                }
                if ("path".equals(fieldName)) {
                    deserializedSessionProbeHttpGet.path = reader.getString();
                    continue;
                }
                if ("scheme".equals(fieldName)) {
                    deserializedSessionProbeHttpGet.scheme = Scheme.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSessionProbeHttpGet;
        });
    }
}

