/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.SessionProbeHttpGet;
import com.azure.resourcemanager.appcontainers.models.SessionProbeTcpSocket;
import com.azure.resourcemanager.appcontainers.models.SessionProbeType;
import java.io.IOException;

public final class SessionProbe
implements JsonSerializable<SessionProbe> {
    private SessionProbeType type;
    private SessionProbeHttpGet httpGet;
    private SessionProbeTcpSocket tcpSocket;
    private Integer failureThreshold;
    private Integer initialDelaySeconds;
    private Integer periodSeconds;
    private Integer successThreshold;
    private Long terminationGracePeriodSeconds;
    private Integer timeoutSeconds;

    public SessionProbeType type() {
        return this.type;
    }

    public SessionProbe withType(SessionProbeType type) {
        this.type = type;
        return this;
    }

    public SessionProbeHttpGet httpGet() {
        return this.httpGet;
    }

    public SessionProbe withHttpGet(SessionProbeHttpGet httpGet) {
        this.httpGet = httpGet;
        return this;
    }

    public SessionProbeTcpSocket tcpSocket() {
        return this.tcpSocket;
    }

    public SessionProbe withTcpSocket(SessionProbeTcpSocket tcpSocket) {
        this.tcpSocket = tcpSocket;
        return this;
    }

    public Integer failureThreshold() {
        return this.failureThreshold;
    }

    public SessionProbe withFailureThreshold(Integer failureThreshold) {
        this.failureThreshold = failureThreshold;
        return this;
    }

    public Integer initialDelaySeconds() {
        return this.initialDelaySeconds;
    }

    public SessionProbe withInitialDelaySeconds(Integer initialDelaySeconds) {
        this.initialDelaySeconds = initialDelaySeconds;
        return this;
    }

    public Integer periodSeconds() {
        return this.periodSeconds;
    }

    public SessionProbe withPeriodSeconds(Integer periodSeconds) {
        this.periodSeconds = periodSeconds;
        return this;
    }

    public Integer successThreshold() {
        return this.successThreshold;
    }

    public SessionProbe withSuccessThreshold(Integer successThreshold) {
        this.successThreshold = successThreshold;
        return this;
    }

    public Long terminationGracePeriodSeconds() {
        return this.terminationGracePeriodSeconds;
    }

    public SessionProbe withTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds) {
        this.terminationGracePeriodSeconds = terminationGracePeriodSeconds;
        return this;
    }

    public Integer timeoutSeconds() {
        return this.timeoutSeconds;
    }

    public SessionProbe withTimeoutSeconds(Integer timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
        return this;
    }

    public void validate() {
        if (this.httpGet() != null) {
            this.httpGet().validate();
        }
        if (this.tcpSocket() != null) {
            this.tcpSocket().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeJsonField("httpGet", (JsonSerializable)this.httpGet);
        jsonWriter.writeJsonField("tcpSocket", (JsonSerializable)this.tcpSocket);
        jsonWriter.writeNumberField("failureThreshold", (Number)this.failureThreshold);
        jsonWriter.writeNumberField("initialDelaySeconds", (Number)this.initialDelaySeconds);
        jsonWriter.writeNumberField("periodSeconds", (Number)this.periodSeconds);
        jsonWriter.writeNumberField("successThreshold", (Number)this.successThreshold);
        jsonWriter.writeNumberField("terminationGracePeriodSeconds", (Number)this.terminationGracePeriodSeconds);
        jsonWriter.writeNumberField("timeoutSeconds", (Number)this.timeoutSeconds);
        return jsonWriter.writeEndObject();
    }

    public static SessionProbe fromJson(JsonReader jsonReader) throws IOException {
        return (SessionProbe)jsonReader.readObject(reader -> {
            SessionProbe deserializedSessionProbe = new SessionProbe();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedSessionProbe.type = SessionProbeType.fromString(reader.getString());
                    continue;
                }
                if ("httpGet".equals(fieldName)) {
                    deserializedSessionProbe.httpGet = SessionProbeHttpGet.fromJson(reader);
                    continue;
                }
                if ("tcpSocket".equals(fieldName)) {
                    deserializedSessionProbe.tcpSocket = SessionProbeTcpSocket.fromJson(reader);
                    continue;
                }
                if ("failureThreshold".equals(fieldName)) {
                    deserializedSessionProbe.failureThreshold = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("initialDelaySeconds".equals(fieldName)) {
                    deserializedSessionProbe.initialDelaySeconds = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("periodSeconds".equals(fieldName)) {
                    deserializedSessionProbe.periodSeconds = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("successThreshold".equals(fieldName)) {
                    deserializedSessionProbe.successThreshold = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("terminationGracePeriodSeconds".equals(fieldName)) {
                    deserializedSessionProbe.terminationGracePeriodSeconds = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("timeoutSeconds".equals(fieldName)) {
                    deserializedSessionProbe.timeoutSeconds = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSessionProbe;
        });
    }
}

