/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.fluent.models.SessionPoolInner;
import java.io.IOException;
import java.util.List;

public final class SessionPoolCollection
implements JsonSerializable<SessionPoolCollection> {
    private List<SessionPoolInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(SessionPoolCollection.class);

    public List<SessionPoolInner> value() {
        return this.value;
    }

    public SessionPoolCollection withValue(List<SessionPoolInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model SessionPoolCollection"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SessionPoolCollection fromJson(JsonReader jsonReader) throws IOException {
        return (SessionPoolCollection)jsonReader.readObject(reader -> {
            SessionPoolCollection deserializedSessionPoolCollection = new SessionPoolCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedSessionPoolCollection.value = value = reader.readArray(reader1 -> SessionPoolInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedSessionPoolCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSessionPoolCollection;
        });
    }
}

