/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class Service
implements JsonSerializable<Service> {
    private String type;
    private static final ClientLogger LOGGER = new ClientLogger(Service.class);

    public String type() {
        return this.type;
    }

    public Service withType(String type) {
        this.type = type;
        return this;
    }

    public void validate() {
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model Service"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static Service fromJson(JsonReader jsonReader) throws IOException {
        return (Service)jsonReader.readObject(reader -> {
            Service deserializedService = new Service();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedService.type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedService;
        });
    }
}

