/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.WeekDay;
import java.io.IOException;

public final class ScheduledEntry
implements JsonSerializable<ScheduledEntry> {
    private WeekDay weekDay;
    private int startHourUtc;
    private int durationHours;
    private static final ClientLogger LOGGER = new ClientLogger(ScheduledEntry.class);

    public WeekDay weekDay() {
        return this.weekDay;
    }

    public ScheduledEntry withWeekDay(WeekDay weekDay) {
        this.weekDay = weekDay;
        return this;
    }

    public int startHourUtc() {
        return this.startHourUtc;
    }

    public ScheduledEntry withStartHourUtc(int startHourUtc) {
        this.startHourUtc = startHourUtc;
        return this;
    }

    public int durationHours() {
        return this.durationHours;
    }

    public ScheduledEntry withDurationHours(int durationHours) {
        this.durationHours = durationHours;
        return this;
    }

    public void validate() {
        if (this.weekDay() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property weekDay in model ScheduledEntry"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("weekDay", this.weekDay == null ? null : this.weekDay.toString());
        jsonWriter.writeIntField("startHourUtc", this.startHourUtc);
        jsonWriter.writeIntField("durationHours", this.durationHours);
        return jsonWriter.writeEndObject();
    }

    public static ScheduledEntry fromJson(JsonReader jsonReader) throws IOException {
        return (ScheduledEntry)jsonReader.readObject(reader -> {
            ScheduledEntry deserializedScheduledEntry = new ScheduledEntry();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("weekDay".equals(fieldName)) {
                    deserializedScheduledEntry.weekDay = WeekDay.fromString(reader.getString());
                    continue;
                }
                if ("startHourUtc".equals(fieldName)) {
                    deserializedScheduledEntry.startHourUtc = reader.getInt();
                    continue;
                }
                if ("durationHours".equals(fieldName)) {
                    deserializedScheduledEntry.durationHours = reader.getInt();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedScheduledEntry;
        });
    }
}

