/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ScgRoute
implements JsonSerializable<ScgRoute> {
    private String id;
    private String uri;
    private List<String> predicates;
    private List<String> filters;
    private Long order;
    private static final ClientLogger LOGGER = new ClientLogger(ScgRoute.class);

    public String id() {
        return this.id;
    }

    public ScgRoute withId(String id) {
        this.id = id;
        return this;
    }

    public String uri() {
        return this.uri;
    }

    public ScgRoute withUri(String uri) {
        this.uri = uri;
        return this;
    }

    public List<String> predicates() {
        return this.predicates;
    }

    public ScgRoute withPredicates(List<String> predicates) {
        this.predicates = predicates;
        return this;
    }

    public List<String> filters() {
        return this.filters;
    }

    public ScgRoute withFilters(List<String> filters) {
        this.filters = filters;
        return this;
    }

    public Long order() {
        return this.order;
    }

    public ScgRoute withOrder(Long order) {
        this.order = order;
        return this;
    }

    public void validate() {
        if (this.id() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property id in model ScgRoute"));
        }
        if (this.uri() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property uri in model ScgRoute"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("uri", this.uri);
        jsonWriter.writeArrayField("predicates", this.predicates, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("filters", this.filters, (writer, element) -> writer.writeString(element));
        jsonWriter.writeNumberField("order", (Number)this.order);
        return jsonWriter.writeEndObject();
    }

    public static ScgRoute fromJson(JsonReader jsonReader) throws IOException {
        return (ScgRoute)jsonReader.readObject(reader -> {
            ScgRoute deserializedScgRoute = new ScgRoute();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedScgRoute.id = reader.getString();
                    continue;
                }
                if ("uri".equals(fieldName)) {
                    deserializedScgRoute.uri = reader.getString();
                    continue;
                }
                if ("predicates".equals(fieldName)) {
                    List predicates;
                    deserializedScgRoute.predicates = predicates = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("filters".equals(fieldName)) {
                    List filters;
                    deserializedScgRoute.filters = filters = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("order".equals(fieldName)) {
                    deserializedScgRoute.order = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedScgRoute;
        });
    }
}

