/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ScaleConfiguration
implements JsonSerializable<ScaleConfiguration> {
    private Integer maxConcurrentSessions;
    private Integer readySessionInstances;

    public Integer maxConcurrentSessions() {
        return this.maxConcurrentSessions;
    }

    public ScaleConfiguration withMaxConcurrentSessions(Integer maxConcurrentSessions) {
        this.maxConcurrentSessions = maxConcurrentSessions;
        return this;
    }

    public Integer readySessionInstances() {
        return this.readySessionInstances;
    }

    public ScaleConfiguration withReadySessionInstances(Integer readySessionInstances) {
        this.readySessionInstances = readySessionInstances;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("maxConcurrentSessions", (Number)this.maxConcurrentSessions);
        jsonWriter.writeNumberField("readySessionInstances", (Number)this.readySessionInstances);
        return jsonWriter.writeEndObject();
    }

    public static ScaleConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (ScaleConfiguration)jsonReader.readObject(reader -> {
            ScaleConfiguration deserializedScaleConfiguration = new ScaleConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("maxConcurrentSessions".equals(fieldName)) {
                    deserializedScaleConfiguration.maxConcurrentSessions = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("readySessionInstances".equals(fieldName)) {
                    deserializedScaleConfiguration.readySessionInstances = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedScaleConfiguration;
        });
    }
}

