/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.ContainerExecutionStatus;
import java.io.IOException;
import java.util.List;

public final class ReplicaExecutionStatus
implements JsonSerializable<ReplicaExecutionStatus> {
    private String name;
    private List<ContainerExecutionStatus> containers;

    public String name() {
        return this.name;
    }

    public ReplicaExecutionStatus withName(String name) {
        this.name = name;
        return this;
    }

    public List<ContainerExecutionStatus> containers() {
        return this.containers;
    }

    public ReplicaExecutionStatus withContainers(List<ContainerExecutionStatus> containers) {
        this.containers = containers;
        return this;
    }

    public void validate() {
        if (this.containers() != null) {
            this.containers().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("containers", this.containers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ReplicaExecutionStatus fromJson(JsonReader jsonReader) throws IOException {
        return (ReplicaExecutionStatus)jsonReader.readObject(reader -> {
            ReplicaExecutionStatus deserializedReplicaExecutionStatus = new ReplicaExecutionStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedReplicaExecutionStatus.name = reader.getString();
                    continue;
                }
                if ("containers".equals(fieldName)) {
                    List containers;
                    deserializedReplicaExecutionStatus.containers = containers = reader.readArray(reader1 -> ContainerExecutionStatus.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedReplicaExecutionStatus;
        });
    }
}

