/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.ContainerAppContainerRunningState;
import java.io.IOException;

public final class ReplicaContainer
implements JsonSerializable<ReplicaContainer> {
    private String name;
    private String containerId;
    private Boolean ready;
    private Boolean started;
    private Integer restartCount;
    private ContainerAppContainerRunningState runningState;
    private String runningStateDetails;
    private String logStreamEndpoint;
    private String execEndpoint;
    private String debugEndpoint;

    public String name() {
        return this.name;
    }

    public ReplicaContainer withName(String name) {
        this.name = name;
        return this;
    }

    public String containerId() {
        return this.containerId;
    }

    public ReplicaContainer withContainerId(String containerId) {
        this.containerId = containerId;
        return this;
    }

    public Boolean ready() {
        return this.ready;
    }

    public ReplicaContainer withReady(Boolean ready) {
        this.ready = ready;
        return this;
    }

    public Boolean started() {
        return this.started;
    }

    public ReplicaContainer withStarted(Boolean started) {
        this.started = started;
        return this;
    }

    public Integer restartCount() {
        return this.restartCount;
    }

    public ReplicaContainer withRestartCount(Integer restartCount) {
        this.restartCount = restartCount;
        return this;
    }

    public ContainerAppContainerRunningState runningState() {
        return this.runningState;
    }

    public String runningStateDetails() {
        return this.runningStateDetails;
    }

    public String logStreamEndpoint() {
        return this.logStreamEndpoint;
    }

    public String execEndpoint() {
        return this.execEndpoint;
    }

    public String debugEndpoint() {
        return this.debugEndpoint;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("containerId", this.containerId);
        jsonWriter.writeBooleanField("ready", this.ready);
        jsonWriter.writeBooleanField("started", this.started);
        jsonWriter.writeNumberField("restartCount", (Number)this.restartCount);
        return jsonWriter.writeEndObject();
    }

    public static ReplicaContainer fromJson(JsonReader jsonReader) throws IOException {
        return (ReplicaContainer)jsonReader.readObject(reader -> {
            ReplicaContainer deserializedReplicaContainer = new ReplicaContainer();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedReplicaContainer.name = reader.getString();
                    continue;
                }
                if ("containerId".equals(fieldName)) {
                    deserializedReplicaContainer.containerId = reader.getString();
                    continue;
                }
                if ("ready".equals(fieldName)) {
                    deserializedReplicaContainer.ready = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("started".equals(fieldName)) {
                    deserializedReplicaContainer.started = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("restartCount".equals(fieldName)) {
                    deserializedReplicaContainer.restartCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("runningState".equals(fieldName)) {
                    deserializedReplicaContainer.runningState = ContainerAppContainerRunningState.fromString(reader.getString());
                    continue;
                }
                if ("runningStateDetails".equals(fieldName)) {
                    deserializedReplicaContainer.runningStateDetails = reader.getString();
                    continue;
                }
                if ("logStreamEndpoint".equals(fieldName)) {
                    deserializedReplicaContainer.logStreamEndpoint = reader.getString();
                    continue;
                }
                if ("execEndpoint".equals(fieldName)) {
                    deserializedReplicaContainer.execEndpoint = reader.getString();
                    continue;
                }
                if ("debugEndpoint".equals(fieldName)) {
                    deserializedReplicaContainer.debugEndpoint = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedReplicaContainer;
        });
    }
}

