/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.HttpGet;
import java.io.IOException;
import java.util.List;

public final class PreBuildStep
implements JsonSerializable<PreBuildStep> {
    private String description;
    private List<String> scripts;
    private HttpGet httpGet;

    public String description() {
        return this.description;
    }

    public PreBuildStep withDescription(String description) {
        this.description = description;
        return this;
    }

    public List<String> scripts() {
        return this.scripts;
    }

    public PreBuildStep withScripts(List<String> scripts) {
        this.scripts = scripts;
        return this;
    }

    public HttpGet httpGet() {
        return this.httpGet;
    }

    public PreBuildStep withHttpGet(HttpGet httpGet) {
        this.httpGet = httpGet;
        return this;
    }

    public void validate() {
        if (this.httpGet() != null) {
            this.httpGet().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeArrayField("scripts", this.scripts, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("httpGet", (JsonSerializable)this.httpGet);
        return jsonWriter.writeEndObject();
    }

    public static PreBuildStep fromJson(JsonReader jsonReader) throws IOException {
        return (PreBuildStep)jsonReader.readObject(reader -> {
            PreBuildStep deserializedPreBuildStep = new PreBuildStep();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedPreBuildStep.description = reader.getString();
                    continue;
                }
                if ("scripts".equals(fieldName)) {
                    List scripts;
                    deserializedPreBuildStep.scripts = scripts = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("httpGet".equals(fieldName)) {
                    deserializedPreBuildStep.httpGet = HttpGet.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPreBuildStep;
        });
    }
}

