/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.DestinationsConfiguration;
import com.azure.resourcemanager.appcontainers.models.LogsConfiguration;
import com.azure.resourcemanager.appcontainers.models.MetricsConfiguration;
import com.azure.resourcemanager.appcontainers.models.TracesConfiguration;
import java.io.IOException;

public final class OpenTelemetryConfiguration
implements JsonSerializable<OpenTelemetryConfiguration> {
    private DestinationsConfiguration destinationsConfiguration;
    private TracesConfiguration tracesConfiguration;
    private LogsConfiguration logsConfiguration;
    private MetricsConfiguration metricsConfiguration;

    public DestinationsConfiguration destinationsConfiguration() {
        return this.destinationsConfiguration;
    }

    public OpenTelemetryConfiguration withDestinationsConfiguration(DestinationsConfiguration destinationsConfiguration) {
        this.destinationsConfiguration = destinationsConfiguration;
        return this;
    }

    public TracesConfiguration tracesConfiguration() {
        return this.tracesConfiguration;
    }

    public OpenTelemetryConfiguration withTracesConfiguration(TracesConfiguration tracesConfiguration) {
        this.tracesConfiguration = tracesConfiguration;
        return this;
    }

    public LogsConfiguration logsConfiguration() {
        return this.logsConfiguration;
    }

    public OpenTelemetryConfiguration withLogsConfiguration(LogsConfiguration logsConfiguration) {
        this.logsConfiguration = logsConfiguration;
        return this;
    }

    public MetricsConfiguration metricsConfiguration() {
        return this.metricsConfiguration;
    }

    public OpenTelemetryConfiguration withMetricsConfiguration(MetricsConfiguration metricsConfiguration) {
        this.metricsConfiguration = metricsConfiguration;
        return this;
    }

    public void validate() {
        if (this.destinationsConfiguration() != null) {
            this.destinationsConfiguration().validate();
        }
        if (this.tracesConfiguration() != null) {
            this.tracesConfiguration().validate();
        }
        if (this.logsConfiguration() != null) {
            this.logsConfiguration().validate();
        }
        if (this.metricsConfiguration() != null) {
            this.metricsConfiguration().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("destinationsConfiguration", (JsonSerializable)this.destinationsConfiguration);
        jsonWriter.writeJsonField("tracesConfiguration", (JsonSerializable)this.tracesConfiguration);
        jsonWriter.writeJsonField("logsConfiguration", (JsonSerializable)this.logsConfiguration);
        jsonWriter.writeJsonField("metricsConfiguration", (JsonSerializable)this.metricsConfiguration);
        return jsonWriter.writeEndObject();
    }

    public static OpenTelemetryConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (OpenTelemetryConfiguration)jsonReader.readObject(reader -> {
            OpenTelemetryConfiguration deserializedOpenTelemetryConfiguration = new OpenTelemetryConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("destinationsConfiguration".equals(fieldName)) {
                    deserializedOpenTelemetryConfiguration.destinationsConfiguration = DestinationsConfiguration.fromJson(reader);
                    continue;
                }
                if ("tracesConfiguration".equals(fieldName)) {
                    deserializedOpenTelemetryConfiguration.tracesConfiguration = TracesConfiguration.fromJson(reader);
                    continue;
                }
                if ("logsConfiguration".equals(fieldName)) {
                    deserializedOpenTelemetryConfiguration.logsConfiguration = LogsConfiguration.fromJson(reader);
                    continue;
                }
                if ("metricsConfiguration".equals(fieldName)) {
                    deserializedOpenTelemetryConfiguration.metricsConfiguration = MetricsConfiguration.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOpenTelemetryConfiguration;
        });
    }
}

