/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.JavaComponentConfigurationProperty;
import com.azure.resourcemanager.appcontainers.models.JavaComponentIngress;
import com.azure.resourcemanager.appcontainers.models.JavaComponentProperties;
import com.azure.resourcemanager.appcontainers.models.JavaComponentPropertiesScale;
import com.azure.resourcemanager.appcontainers.models.JavaComponentProvisioningState;
import com.azure.resourcemanager.appcontainers.models.JavaComponentServiceBind;
import com.azure.resourcemanager.appcontainers.models.JavaComponentType;
import java.io.IOException;
import java.util.List;

public final class NacosComponent
extends JavaComponentProperties {
    private JavaComponentType componentType = JavaComponentType.NACOS;
    private JavaComponentIngress ingress;

    @Override
    public JavaComponentType componentType() {
        return this.componentType;
    }

    public JavaComponentIngress ingress() {
        return this.ingress;
    }

    public NacosComponent withIngress(JavaComponentIngress ingress) {
        this.ingress = ingress;
        return this;
    }

    @Override
    public NacosComponent withConfigurations(List<JavaComponentConfigurationProperty> configurations) {
        super.withConfigurations(configurations);
        return this;
    }

    @Override
    public NacosComponent withScale(JavaComponentPropertiesScale scale) {
        super.withScale(scale);
        return this;
    }

    @Override
    public NacosComponent withServiceBinds(List<JavaComponentServiceBind> serviceBinds) {
        super.withServiceBinds(serviceBinds);
        return this;
    }

    @Override
    public void validate() {
        if (this.ingress() != null) {
            this.ingress().validate();
        }
        if (this.configurations() != null) {
            this.configurations().forEach(e -> e.validate());
        }
        if (this.scale() != null) {
            this.scale().validate();
        }
        if (this.serviceBinds() != null) {
            this.serviceBinds().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("configurations", this.configurations(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("scale", (JsonSerializable)this.scale());
        jsonWriter.writeArrayField("serviceBinds", this.serviceBinds(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("componentType", this.componentType == null ? null : this.componentType.toString());
        jsonWriter.writeJsonField("ingress", (JsonSerializable)this.ingress);
        return jsonWriter.writeEndObject();
    }

    public static NacosComponent fromJson(JsonReader jsonReader) throws IOException {
        return (NacosComponent)jsonReader.readObject(reader -> {
            NacosComponent deserializedNacosComponent = new NacosComponent();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedNacosComponent.withProvisioningState(JavaComponentProvisioningState.fromString(reader.getString()));
                    continue;
                }
                if ("configurations".equals(fieldName)) {
                    List configurations = reader.readArray(reader1 -> JavaComponentConfigurationProperty.fromJson(reader1));
                    deserializedNacosComponent.withConfigurations(configurations);
                    continue;
                }
                if ("scale".equals(fieldName)) {
                    deserializedNacosComponent.withScale(JavaComponentPropertiesScale.fromJson(reader));
                    continue;
                }
                if ("serviceBinds".equals(fieldName)) {
                    List serviceBinds = reader.readArray(reader1 -> JavaComponentServiceBind.fromJson(reader1));
                    deserializedNacosComponent.withServiceBinds(serviceBinds);
                    continue;
                }
                if ("componentType".equals(fieldName)) {
                    deserializedNacosComponent.componentType = JavaComponentType.fromString(reader.getString());
                    continue;
                }
                if ("ingress".equals(fieldName)) {
                    deserializedNacosComponent.ingress = JavaComponentIngress.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNacosComponent;
        });
    }
}

