/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.fluent.models.ManagedEnvironmentInner;
import com.azure.resourcemanager.appcontainers.models.AppInsightsConfiguration;
import com.azure.resourcemanager.appcontainers.models.AppLogsConfiguration;
import com.azure.resourcemanager.appcontainers.models.CustomDomainConfiguration;
import com.azure.resourcemanager.appcontainers.models.DaprConfiguration;
import com.azure.resourcemanager.appcontainers.models.DiskEncryptionConfiguration;
import com.azure.resourcemanager.appcontainers.models.EnvironmentAuthToken;
import com.azure.resourcemanager.appcontainers.models.EnvironmentProvisioningState;
import com.azure.resourcemanager.appcontainers.models.IngressConfiguration;
import com.azure.resourcemanager.appcontainers.models.KedaConfiguration;
import com.azure.resourcemanager.appcontainers.models.ManagedEnvironmentPropertiesPeerAuthentication;
import com.azure.resourcemanager.appcontainers.models.ManagedEnvironmentPropertiesPeerTrafficConfiguration;
import com.azure.resourcemanager.appcontainers.models.ManagedServiceIdentity;
import com.azure.resourcemanager.appcontainers.models.OpenTelemetryConfiguration;
import com.azure.resourcemanager.appcontainers.models.PrivateEndpointConnection;
import com.azure.resourcemanager.appcontainers.models.PublicNetworkAccess;
import com.azure.resourcemanager.appcontainers.models.VnetConfiguration;
import com.azure.resourcemanager.appcontainers.models.WorkloadProfile;
import java.util.List;
import java.util.Map;

public interface ManagedEnvironment {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public String kind();

    public ManagedServiceIdentity identity();

    public SystemData systemData();

    public EnvironmentProvisioningState provisioningState();

    public String daprAIInstrumentationKey();

    public String daprAIConnectionString();

    public VnetConfiguration vnetConfiguration();

    public String deploymentErrors();

    public String defaultDomain();

    public String privateLinkDefaultDomain();

    public String staticIp();

    public AppLogsConfiguration appLogsConfiguration();

    public AppInsightsConfiguration appInsightsConfiguration();

    public OpenTelemetryConfiguration openTelemetryConfiguration();

    public Boolean zoneRedundant();

    public List<String> availabilityZones();

    public CustomDomainConfiguration customDomainConfiguration();

    public String eventStreamEndpoint();

    public List<WorkloadProfile> workloadProfiles();

    public KedaConfiguration kedaConfiguration();

    public DaprConfiguration daprConfiguration();

    public String infrastructureResourceGroup();

    public ManagedEnvironmentPropertiesPeerAuthentication peerAuthentication();

    public ManagedEnvironmentPropertiesPeerTrafficConfiguration peerTrafficConfiguration();

    public IngressConfiguration ingressConfiguration();

    public List<PrivateEndpointConnection> privateEndpointConnections();

    public PublicNetworkAccess publicNetworkAccess();

    public DiskEncryptionConfiguration diskEncryptionConfiguration();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public ManagedEnvironmentInner innerModel();

    public Update update();

    public ManagedEnvironment refresh();

    public ManagedEnvironment refresh(Context var1);

    public Response<EnvironmentAuthToken> getAuthTokenWithResponse(Context var1);

    public EnvironmentAuthToken getAuthToken();

    public static interface UpdateStages {

        public static interface WithDiskEncryptionConfiguration {
            public Update withDiskEncryptionConfiguration(DiskEncryptionConfiguration var1);
        }

        public static interface WithPublicNetworkAccess {
            public Update withPublicNetworkAccess(PublicNetworkAccess var1);
        }

        public static interface WithIngressConfiguration {
            public Update withIngressConfiguration(IngressConfiguration var1);
        }

        public static interface WithPeerTrafficConfiguration {
            public Update withPeerTrafficConfiguration(ManagedEnvironmentPropertiesPeerTrafficConfiguration var1);
        }

        public static interface WithPeerAuthentication {
            public Update withPeerAuthentication(ManagedEnvironmentPropertiesPeerAuthentication var1);
        }

        public static interface WithDaprConfiguration {
            public Update withDaprConfiguration(DaprConfiguration var1);
        }

        public static interface WithKedaConfiguration {
            public Update withKedaConfiguration(KedaConfiguration var1);
        }

        public static interface WithWorkloadProfiles {
            public Update withWorkloadProfiles(List<WorkloadProfile> var1);
        }

        public static interface WithCustomDomainConfiguration {
            public Update withCustomDomainConfiguration(CustomDomainConfiguration var1);
        }

        public static interface WithAvailabilityZones {
            public Update withAvailabilityZones(List<String> var1);
        }

        public static interface WithOpenTelemetryConfiguration {
            public Update withOpenTelemetryConfiguration(OpenTelemetryConfiguration var1);
        }

        public static interface WithAppInsightsConfiguration {
            public Update withAppInsightsConfiguration(AppInsightsConfiguration var1);
        }

        public static interface WithAppLogsConfiguration {
            public Update withAppLogsConfiguration(AppLogsConfiguration var1);
        }

        public static interface WithVnetConfiguration {
            public Update withVnetConfiguration(VnetConfiguration var1);
        }

        public static interface WithDaprAIConnectionString {
            public Update withDaprAIConnectionString(String var1);
        }

        public static interface WithDaprAIInstrumentationKey {
            public Update withDaprAIInstrumentationKey(String var1);
        }

        public static interface WithIdentity {
            public Update withIdentity(ManagedServiceIdentity var1);
        }

        public static interface WithKind {
            public Update withKind(String var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithKind,
    UpdateStages.WithIdentity,
    UpdateStages.WithDaprAIInstrumentationKey,
    UpdateStages.WithDaprAIConnectionString,
    UpdateStages.WithVnetConfiguration,
    UpdateStages.WithAppLogsConfiguration,
    UpdateStages.WithAppInsightsConfiguration,
    UpdateStages.WithOpenTelemetryConfiguration,
    UpdateStages.WithAvailabilityZones,
    UpdateStages.WithCustomDomainConfiguration,
    UpdateStages.WithWorkloadProfiles,
    UpdateStages.WithKedaConfiguration,
    UpdateStages.WithDaprConfiguration,
    UpdateStages.WithPeerAuthentication,
    UpdateStages.WithPeerTrafficConfiguration,
    UpdateStages.WithIngressConfiguration,
    UpdateStages.WithPublicNetworkAccess,
    UpdateStages.WithDiskEncryptionConfiguration {
        public ManagedEnvironment apply();

        public ManagedEnvironment apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithDiskEncryptionConfiguration {
            public WithCreate withDiskEncryptionConfiguration(DiskEncryptionConfiguration var1);
        }

        public static interface WithPublicNetworkAccess {
            public WithCreate withPublicNetworkAccess(PublicNetworkAccess var1);
        }

        public static interface WithIngressConfiguration {
            public WithCreate withIngressConfiguration(IngressConfiguration var1);
        }

        public static interface WithPeerTrafficConfiguration {
            public WithCreate withPeerTrafficConfiguration(ManagedEnvironmentPropertiesPeerTrafficConfiguration var1);
        }

        public static interface WithPeerAuthentication {
            public WithCreate withPeerAuthentication(ManagedEnvironmentPropertiesPeerAuthentication var1);
        }

        public static interface WithInfrastructureResourceGroup {
            public WithCreate withInfrastructureResourceGroup(String var1);
        }

        public static interface WithDaprConfiguration {
            public WithCreate withDaprConfiguration(DaprConfiguration var1);
        }

        public static interface WithKedaConfiguration {
            public WithCreate withKedaConfiguration(KedaConfiguration var1);
        }

        public static interface WithWorkloadProfiles {
            public WithCreate withWorkloadProfiles(List<WorkloadProfile> var1);
        }

        public static interface WithCustomDomainConfiguration {
            public WithCreate withCustomDomainConfiguration(CustomDomainConfiguration var1);
        }

        public static interface WithAvailabilityZones {
            public WithCreate withAvailabilityZones(List<String> var1);
        }

        public static interface WithZoneRedundant {
            public WithCreate withZoneRedundant(Boolean var1);
        }

        public static interface WithOpenTelemetryConfiguration {
            public WithCreate withOpenTelemetryConfiguration(OpenTelemetryConfiguration var1);
        }

        public static interface WithAppInsightsConfiguration {
            public WithCreate withAppInsightsConfiguration(AppInsightsConfiguration var1);
        }

        public static interface WithAppLogsConfiguration {
            public WithCreate withAppLogsConfiguration(AppLogsConfiguration var1);
        }

        public static interface WithVnetConfiguration {
            public WithCreate withVnetConfiguration(VnetConfiguration var1);
        }

        public static interface WithDaprAIConnectionString {
            public WithCreate withDaprAIConnectionString(String var1);
        }

        public static interface WithDaprAIInstrumentationKey {
            public WithCreate withDaprAIInstrumentationKey(String var1);
        }

        public static interface WithIdentity {
            public WithCreate withIdentity(ManagedServiceIdentity var1);
        }

        public static interface WithKind {
            public WithCreate withKind(String var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithKind,
        WithIdentity,
        WithDaprAIInstrumentationKey,
        WithDaprAIConnectionString,
        WithVnetConfiguration,
        WithAppLogsConfiguration,
        WithAppInsightsConfiguration,
        WithOpenTelemetryConfiguration,
        WithZoneRedundant,
        WithAvailabilityZones,
        WithCustomDomainConfiguration,
        WithWorkloadProfiles,
        WithKedaConfiguration,
        WithDaprConfiguration,
        WithInfrastructureResourceGroup,
        WithPeerAuthentication,
        WithPeerTrafficConfiguration,
        WithIngressConfiguration,
        WithPublicNetworkAccess,
        WithDiskEncryptionConfiguration {
            public ManagedEnvironment create();

            public ManagedEnvironment create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

