/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.Status;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class LabelHistoryRecordItem
implements JsonSerializable<LabelHistoryRecordItem> {
    private String revision;
    private OffsetDateTime start;
    private OffsetDateTime stop;
    private Status status;

    public String revision() {
        return this.revision;
    }

    public OffsetDateTime start() {
        return this.start;
    }

    public OffsetDateTime stop() {
        return this.stop;
    }

    public Status status() {
        return this.status;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static LabelHistoryRecordItem fromJson(JsonReader jsonReader) throws IOException {
        return (LabelHistoryRecordItem)jsonReader.readObject(reader -> {
            LabelHistoryRecordItem deserializedLabelHistoryRecordItem = new LabelHistoryRecordItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("revision".equals(fieldName)) {
                    deserializedLabelHistoryRecordItem.revision = reader.getString();
                    continue;
                }
                if ("start".equals(fieldName)) {
                    deserializedLabelHistoryRecordItem.start = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("stop".equals(fieldName)) {
                    deserializedLabelHistoryRecordItem.stop = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedLabelHistoryRecordItem.status = Status.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLabelHistoryRecordItem;
        });
    }
}

