/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.fluent.models.JobInner;
import java.io.IOException;
import java.util.List;

public final class JobsCollection
implements JsonSerializable<JobsCollection> {
    private List<JobInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(JobsCollection.class);

    public List<JobInner> value() {
        return this.value;
    }

    public JobsCollection withValue(List<JobInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model JobsCollection"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static JobsCollection fromJson(JsonReader jsonReader) throws IOException {
        return (JobsCollection)jsonReader.readObject(reader -> {
            JobsCollection deserializedJobsCollection = new JobsCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedJobsCollection.value = value = reader.readArray(reader1 -> JobInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedJobsCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobsCollection;
        });
    }
}

