/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.JavaComponentConfigurationProperty;
import com.azure.resourcemanager.appcontainers.models.JavaComponentPropertiesScale;
import com.azure.resourcemanager.appcontainers.models.JavaComponentProvisioningState;
import com.azure.resourcemanager.appcontainers.models.JavaComponentServiceBind;
import com.azure.resourcemanager.appcontainers.models.JavaComponentType;
import com.azure.resourcemanager.appcontainers.models.NacosComponent;
import com.azure.resourcemanager.appcontainers.models.SpringBootAdminComponent;
import com.azure.resourcemanager.appcontainers.models.SpringCloudConfigComponent;
import com.azure.resourcemanager.appcontainers.models.SpringCloudEurekaComponent;
import com.azure.resourcemanager.appcontainers.models.SpringCloudGatewayComponent;
import java.io.IOException;
import java.util.List;

public class JavaComponentProperties
implements JsonSerializable<JavaComponentProperties> {
    private JavaComponentType componentType = JavaComponentType.fromString("JavaComponentProperties");
    private JavaComponentProvisioningState provisioningState;
    private List<JavaComponentConfigurationProperty> configurations;
    private JavaComponentPropertiesScale scale;
    private List<JavaComponentServiceBind> serviceBinds;

    public JavaComponentType componentType() {
        return this.componentType;
    }

    public JavaComponentProvisioningState provisioningState() {
        return this.provisioningState;
    }

    JavaComponentProperties withProvisioningState(JavaComponentProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public List<JavaComponentConfigurationProperty> configurations() {
        return this.configurations;
    }

    public JavaComponentProperties withConfigurations(List<JavaComponentConfigurationProperty> configurations) {
        this.configurations = configurations;
        return this;
    }

    public JavaComponentPropertiesScale scale() {
        return this.scale;
    }

    public JavaComponentProperties withScale(JavaComponentPropertiesScale scale) {
        this.scale = scale;
        return this;
    }

    public List<JavaComponentServiceBind> serviceBinds() {
        return this.serviceBinds;
    }

    public JavaComponentProperties withServiceBinds(List<JavaComponentServiceBind> serviceBinds) {
        this.serviceBinds = serviceBinds;
        return this;
    }

    public void validate() {
        if (this.configurations() != null) {
            this.configurations().forEach(e -> e.validate());
        }
        if (this.scale() != null) {
            this.scale().validate();
        }
        if (this.serviceBinds() != null) {
            this.serviceBinds().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("componentType", this.componentType == null ? null : this.componentType.toString());
        jsonWriter.writeArrayField("configurations", this.configurations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("scale", (JsonSerializable)this.scale);
        jsonWriter.writeArrayField("serviceBinds", this.serviceBinds, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static JavaComponentProperties fromJson(JsonReader jsonReader) throws IOException {
        return (JavaComponentProperties)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                JavaComponentProperties javaComponentProperties;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("componentType".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("SpringCloudGateway".equals(discriminatorValue)) {
                    javaComponentProperties = SpringCloudGatewayComponent.fromJson(readerToUse.reset());
                    return javaComponentProperties;
                }
                if ("SpringBootAdmin".equals(discriminatorValue)) {
                    javaComponentProperties = SpringBootAdminComponent.fromJson(readerToUse.reset());
                    return javaComponentProperties;
                }
                if ("Nacos".equals(discriminatorValue)) {
                    javaComponentProperties = NacosComponent.fromJson(readerToUse.reset());
                    return javaComponentProperties;
                }
                if ("SpringCloudEureka".equals(discriminatorValue)) {
                    javaComponentProperties = SpringCloudEurekaComponent.fromJson(readerToUse.reset());
                    return javaComponentProperties;
                }
                if ("SpringCloudConfig".equals(discriminatorValue)) {
                    javaComponentProperties = SpringCloudConfigComponent.fromJson(readerToUse.reset());
                    return javaComponentProperties;
                }
                javaComponentProperties = JavaComponentProperties.fromJsonKnownDiscriminator(readerToUse.reset());
                return javaComponentProperties;
            }
        });
    }

    static JavaComponentProperties fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (JavaComponentProperties)jsonReader.readObject(reader -> {
            JavaComponentProperties deserializedJavaComponentProperties = new JavaComponentProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("componentType".equals(fieldName)) {
                    deserializedJavaComponentProperties.componentType = JavaComponentType.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedJavaComponentProperties.provisioningState = JavaComponentProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("configurations".equals(fieldName)) {
                    List configurations;
                    deserializedJavaComponentProperties.configurations = configurations = reader.readArray(reader1 -> JavaComponentConfigurationProperty.fromJson(reader1));
                    continue;
                }
                if ("scale".equals(fieldName)) {
                    deserializedJavaComponentProperties.scale = JavaComponentPropertiesScale.fromJson(reader);
                    continue;
                }
                if ("serviceBinds".equals(fieldName)) {
                    List serviceBinds;
                    deserializedJavaComponentProperties.serviceBinds = serviceBinds = reader.readArray(reader1 -> JavaComponentServiceBind.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJavaComponentProperties;
        });
    }
}

