/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.BaseContainer;
import com.azure.resourcemanager.appcontainers.models.ContainerResources;
import com.azure.resourcemanager.appcontainers.models.EnvironmentVar;
import com.azure.resourcemanager.appcontainers.models.ImageType;
import com.azure.resourcemanager.appcontainers.models.VolumeMount;
import java.io.IOException;
import java.util.List;

public final class InitContainer
extends BaseContainer {
    @Override
    public InitContainer withImage(String image) {
        super.withImage(image);
        return this;
    }

    @Override
    public InitContainer withImageType(ImageType imageType) {
        super.withImageType(imageType);
        return this;
    }

    @Override
    public InitContainer withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public InitContainer withCommand(List<String> command) {
        super.withCommand(command);
        return this;
    }

    @Override
    public InitContainer withArgs(List<String> args) {
        super.withArgs(args);
        return this;
    }

    @Override
    public InitContainer withEnv(List<EnvironmentVar> env) {
        super.withEnv(env);
        return this;
    }

    @Override
    public InitContainer withResources(ContainerResources resources) {
        super.withResources(resources);
        return this;
    }

    @Override
    public InitContainer withVolumeMounts(List<VolumeMount> volumeMounts) {
        super.withVolumeMounts(volumeMounts);
        return this;
    }

    @Override
    public void validate() {
        if (this.env() != null) {
            this.env().forEach(e -> e.validate());
        }
        if (this.resources() != null) {
            this.resources().validate();
        }
        if (this.volumeMounts() != null) {
            this.volumeMounts().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("image", this.image());
        jsonWriter.writeStringField("imageType", this.imageType() == null ? null : this.imageType().toString());
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeArrayField("command", this.command(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("args", this.args(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("env", this.env(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("resources", (JsonSerializable)this.resources());
        jsonWriter.writeArrayField("volumeMounts", this.volumeMounts(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static InitContainer fromJson(JsonReader jsonReader) throws IOException {
        return (InitContainer)jsonReader.readObject(reader -> {
            InitContainer deserializedInitContainer = new InitContainer();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("image".equals(fieldName)) {
                    deserializedInitContainer.withImage(reader.getString());
                    continue;
                }
                if ("imageType".equals(fieldName)) {
                    deserializedInitContainer.withImageType(ImageType.fromString(reader.getString()));
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedInitContainer.withName(reader.getString());
                    continue;
                }
                if ("command".equals(fieldName)) {
                    List command = reader.readArray(reader1 -> reader1.getString());
                    deserializedInitContainer.withCommand(command);
                    continue;
                }
                if ("args".equals(fieldName)) {
                    List args = reader.readArray(reader1 -> reader1.getString());
                    deserializedInitContainer.withArgs(args);
                    continue;
                }
                if ("env".equals(fieldName)) {
                    List env = reader.readArray(reader1 -> EnvironmentVar.fromJson(reader1));
                    deserializedInitContainer.withEnv(env);
                    continue;
                }
                if ("resources".equals(fieldName)) {
                    deserializedInitContainer.withResources(ContainerResources.fromJson(reader));
                    continue;
                }
                if ("volumeMounts".equals(fieldName)) {
                    List volumeMounts = reader.readArray(reader1 -> VolumeMount.fromJson(reader1));
                    deserializedInitContainer.withVolumeMounts(volumeMounts);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedInitContainer;
        });
    }
}

