/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class IngressPortMapping
implements JsonSerializable<IngressPortMapping> {
    private boolean external;
    private int targetPort;
    private Integer exposedPort;

    public boolean external() {
        return this.external;
    }

    public IngressPortMapping withExternal(boolean external) {
        this.external = external;
        return this;
    }

    public int targetPort() {
        return this.targetPort;
    }

    public IngressPortMapping withTargetPort(int targetPort) {
        this.targetPort = targetPort;
        return this;
    }

    public Integer exposedPort() {
        return this.exposedPort;
    }

    public IngressPortMapping withExposedPort(Integer exposedPort) {
        this.exposedPort = exposedPort;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("external", this.external);
        jsonWriter.writeIntField("targetPort", this.targetPort);
        jsonWriter.writeNumberField("exposedPort", (Number)this.exposedPort);
        return jsonWriter.writeEndObject();
    }

    public static IngressPortMapping fromJson(JsonReader jsonReader) throws IOException {
        return (IngressPortMapping)jsonReader.readObject(reader -> {
            IngressPortMapping deserializedIngressPortMapping = new IngressPortMapping();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("external".equals(fieldName)) {
                    deserializedIngressPortMapping.external = reader.getBoolean();
                    continue;
                }
                if ("targetPort".equals(fieldName)) {
                    deserializedIngressPortMapping.targetPort = reader.getInt();
                    continue;
                }
                if ("exposedPort".equals(fieldName)) {
                    deserializedIngressPortMapping.exposedPort = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIngressPortMapping;
        });
    }
}

