/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.IngressConfigurationScale;
import java.io.IOException;

public final class IngressConfiguration
implements JsonSerializable<IngressConfiguration> {
    private String workloadProfileName;
    private IngressConfigurationScale scale;
    private Integer terminationGracePeriodSeconds;
    private Integer headerCountLimit;
    private Integer requestIdleTimeout;

    public String workloadProfileName() {
        return this.workloadProfileName;
    }

    public IngressConfiguration withWorkloadProfileName(String workloadProfileName) {
        this.workloadProfileName = workloadProfileName;
        return this;
    }

    public IngressConfigurationScale scale() {
        return this.scale;
    }

    public IngressConfiguration withScale(IngressConfigurationScale scale) {
        this.scale = scale;
        return this;
    }

    public Integer terminationGracePeriodSeconds() {
        return this.terminationGracePeriodSeconds;
    }

    public IngressConfiguration withTerminationGracePeriodSeconds(Integer terminationGracePeriodSeconds) {
        this.terminationGracePeriodSeconds = terminationGracePeriodSeconds;
        return this;
    }

    public Integer headerCountLimit() {
        return this.headerCountLimit;
    }

    public IngressConfiguration withHeaderCountLimit(Integer headerCountLimit) {
        this.headerCountLimit = headerCountLimit;
        return this;
    }

    public Integer requestIdleTimeout() {
        return this.requestIdleTimeout;
    }

    public IngressConfiguration withRequestIdleTimeout(Integer requestIdleTimeout) {
        this.requestIdleTimeout = requestIdleTimeout;
        return this;
    }

    public void validate() {
        if (this.scale() != null) {
            this.scale().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("workloadProfileName", this.workloadProfileName);
        jsonWriter.writeJsonField("scale", (JsonSerializable)this.scale);
        jsonWriter.writeNumberField("terminationGracePeriodSeconds", (Number)this.terminationGracePeriodSeconds);
        jsonWriter.writeNumberField("headerCountLimit", (Number)this.headerCountLimit);
        jsonWriter.writeNumberField("requestIdleTimeout", (Number)this.requestIdleTimeout);
        return jsonWriter.writeEndObject();
    }

    public static IngressConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (IngressConfiguration)jsonReader.readObject(reader -> {
            IngressConfiguration deserializedIngressConfiguration = new IngressConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("workloadProfileName".equals(fieldName)) {
                    deserializedIngressConfiguration.workloadProfileName = reader.getString();
                    continue;
                }
                if ("scale".equals(fieldName)) {
                    deserializedIngressConfiguration.scale = IngressConfigurationScale.fromJson(reader);
                    continue;
                }
                if ("terminationGracePeriodSeconds".equals(fieldName)) {
                    deserializedIngressConfiguration.terminationGracePeriodSeconds = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("headerCountLimit".equals(fieldName)) {
                    deserializedIngressConfiguration.headerCountLimit = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("requestIdleTimeout".equals(fieldName)) {
                    deserializedIngressConfiguration.requestIdleTimeout = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIngressConfiguration;
        });
    }
}

