/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.ScaleRuleAuth;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class HttpScaleRule
implements JsonSerializable<HttpScaleRule> {
    private Map<String, String> metadata;
    private List<ScaleRuleAuth> auth;
    private String identity;

    public Map<String, String> metadata() {
        return this.metadata;
    }

    public HttpScaleRule withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public List<ScaleRuleAuth> auth() {
        return this.auth;
    }

    public HttpScaleRule withAuth(List<ScaleRuleAuth> auth) {
        this.auth = auth;
        return this;
    }

    public String identity() {
        return this.identity;
    }

    public HttpScaleRule withIdentity(String identity) {
        this.identity = identity;
        return this;
    }

    public void validate() {
        if (this.auth() != null) {
            this.auth().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("auth", this.auth, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("identity", this.identity);
        return jsonWriter.writeEndObject();
    }

    public static HttpScaleRule fromJson(JsonReader jsonReader) throws IOException {
        return (HttpScaleRule)jsonReader.readObject(reader -> {
            HttpScaleRule deserializedHttpScaleRule = new HttpScaleRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("metadata".equals(fieldName)) {
                    Map metadata;
                    deserializedHttpScaleRule.metadata = metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("auth".equals(fieldName)) {
                    List auth;
                    deserializedHttpScaleRule.auth = auth = reader.readArray(reader1 -> ScaleRuleAuth.fromJson(reader1));
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedHttpScaleRule.identity = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHttpScaleRule;
        });
    }
}

