/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class HttpRouteTarget
implements JsonSerializable<HttpRouteTarget> {
    private String containerApp;
    private String revision;
    private String label;
    private Integer weight;
    private static final ClientLogger LOGGER = new ClientLogger(HttpRouteTarget.class);

    public String containerApp() {
        return this.containerApp;
    }

    public HttpRouteTarget withContainerApp(String containerApp) {
        this.containerApp = containerApp;
        return this;
    }

    public String revision() {
        return this.revision;
    }

    public HttpRouteTarget withRevision(String revision) {
        this.revision = revision;
        return this;
    }

    public String label() {
        return this.label;
    }

    public HttpRouteTarget withLabel(String label) {
        this.label = label;
        return this;
    }

    public Integer weight() {
        return this.weight;
    }

    public HttpRouteTarget withWeight(Integer weight) {
        this.weight = weight;
        return this;
    }

    public void validate() {
        if (this.containerApp() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property containerApp in model HttpRouteTarget"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("containerApp", this.containerApp);
        jsonWriter.writeStringField("revision", this.revision);
        jsonWriter.writeStringField("label", this.label);
        jsonWriter.writeNumberField("weight", (Number)this.weight);
        return jsonWriter.writeEndObject();
    }

    public static HttpRouteTarget fromJson(JsonReader jsonReader) throws IOException {
        return (HttpRouteTarget)jsonReader.readObject(reader -> {
            HttpRouteTarget deserializedHttpRouteTarget = new HttpRouteTarget();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("containerApp".equals(fieldName)) {
                    deserializedHttpRouteTarget.containerApp = reader.getString();
                    continue;
                }
                if ("revision".equals(fieldName)) {
                    deserializedHttpRouteTarget.revision = reader.getString();
                    continue;
                }
                if ("label".equals(fieldName)) {
                    deserializedHttpRouteTarget.label = reader.getString();
                    continue;
                }
                if ("weight".equals(fieldName)) {
                    deserializedHttpRouteTarget.weight = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHttpRouteTarget;
        });
    }
}

