/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.HttpRouteAction;
import com.azure.resourcemanager.appcontainers.models.HttpRouteMatch;
import java.io.IOException;

public final class HttpRoute
implements JsonSerializable<HttpRoute> {
    private HttpRouteMatch match;
    private HttpRouteAction action;

    public HttpRouteMatch match() {
        return this.match;
    }

    public HttpRoute withMatch(HttpRouteMatch match) {
        this.match = match;
        return this;
    }

    public HttpRouteAction action() {
        return this.action;
    }

    public HttpRoute withAction(HttpRouteAction action) {
        this.action = action;
        return this;
    }

    public void validate() {
        if (this.match() != null) {
            this.match().validate();
        }
        if (this.action() != null) {
            this.action().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("match", (JsonSerializable)this.match);
        jsonWriter.writeJsonField("action", (JsonSerializable)this.action);
        return jsonWriter.writeEndObject();
    }

    public static HttpRoute fromJson(JsonReader jsonReader) throws IOException {
        return (HttpRoute)jsonReader.readObject(reader -> {
            HttpRoute deserializedHttpRoute = new HttpRoute();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("match".equals(fieldName)) {
                    deserializedHttpRoute.match = HttpRouteMatch.fromJson(reader);
                    continue;
                }
                if ("action".equals(fieldName)) {
                    deserializedHttpRoute.action = HttpRouteAction.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHttpRoute;
        });
    }
}

