/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class HttpGet
implements JsonSerializable<HttpGet> {
    private String url;
    private String fileName;
    private List<String> headers;
    private static final ClientLogger LOGGER = new ClientLogger(HttpGet.class);

    public String url() {
        return this.url;
    }

    public HttpGet withUrl(String url) {
        this.url = url;
        return this;
    }

    public String fileName() {
        return this.fileName;
    }

    public HttpGet withFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public List<String> headers() {
        return this.headers;
    }

    public HttpGet withHeaders(List<String> headers) {
        this.headers = headers;
        return this;
    }

    public void validate() {
        if (this.url() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property url in model HttpGet"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("url", this.url);
        jsonWriter.writeStringField("fileName", this.fileName);
        jsonWriter.writeArrayField("headers", this.headers, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static HttpGet fromJson(JsonReader jsonReader) throws IOException {
        return (HttpGet)jsonReader.readObject(reader -> {
            HttpGet deserializedHttpGet = new HttpGet();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("url".equals(fieldName)) {
                    deserializedHttpGet.url = reader.getString();
                    continue;
                }
                if ("fileName".equals(fieldName)) {
                    deserializedHttpGet.fileName = reader.getString();
                    continue;
                }
                if ("headers".equals(fieldName)) {
                    List headers;
                    deserializedHttpGet.headers = headers = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHttpGet;
        });
    }
}

