/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class HttpConnectionPool
implements JsonSerializable<HttpConnectionPool> {
    private Integer http1MaxPendingRequests;
    private Integer http2MaxRequests;

    public Integer http1MaxPendingRequests() {
        return this.http1MaxPendingRequests;
    }

    public HttpConnectionPool withHttp1MaxPendingRequests(Integer http1MaxPendingRequests) {
        this.http1MaxPendingRequests = http1MaxPendingRequests;
        return this;
    }

    public Integer http2MaxRequests() {
        return this.http2MaxRequests;
    }

    public HttpConnectionPool withHttp2MaxRequests(Integer http2MaxRequests) {
        this.http2MaxRequests = http2MaxRequests;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("http1MaxPendingRequests", (Number)this.http1MaxPendingRequests);
        jsonWriter.writeNumberField("http2MaxRequests", (Number)this.http2MaxRequests);
        return jsonWriter.writeEndObject();
    }

    public static HttpConnectionPool fromJson(JsonReader jsonReader) throws IOException {
        return (HttpConnectionPool)jsonReader.readObject(reader -> {
            HttpConnectionPool deserializedHttpConnectionPool = new HttpConnectionPool();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("http1MaxPendingRequests".equals(fieldName)) {
                    deserializedHttpConnectionPool.http1MaxPendingRequests = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("http2MaxRequests".equals(fieldName)) {
                    deserializedHttpConnectionPool.http2MaxRequests = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHttpConnectionPool;
        });
    }
}

