/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.fluent.models.HeaderMatchMatch;
import java.io.IOException;

public final class HeaderMatch
implements JsonSerializable<HeaderMatch> {
    private String headerProperty;
    private HeaderMatchMatch innerMatch;

    public String headerProperty() {
        return this.headerProperty;
    }

    public HeaderMatch withHeaderProperty(String headerProperty) {
        this.headerProperty = headerProperty;
        return this;
    }

    private HeaderMatchMatch innerMatch() {
        return this.innerMatch;
    }

    public String exactMatch() {
        return this.innerMatch() == null ? null : this.innerMatch().exactMatch();
    }

    public HeaderMatch withExactMatch(String exactMatch) {
        if (this.innerMatch() == null) {
            this.innerMatch = new HeaderMatchMatch();
        }
        this.innerMatch().withExactMatch(exactMatch);
        return this;
    }

    public String prefixMatch() {
        return this.innerMatch() == null ? null : this.innerMatch().prefixMatch();
    }

    public HeaderMatch withPrefixMatch(String prefixMatch) {
        if (this.innerMatch() == null) {
            this.innerMatch = new HeaderMatchMatch();
        }
        this.innerMatch().withPrefixMatch(prefixMatch);
        return this;
    }

    public String suffixMatch() {
        return this.innerMatch() == null ? null : this.innerMatch().suffixMatch();
    }

    public HeaderMatch withSuffixMatch(String suffixMatch) {
        if (this.innerMatch() == null) {
            this.innerMatch = new HeaderMatchMatch();
        }
        this.innerMatch().withSuffixMatch(suffixMatch);
        return this;
    }

    public String regexMatch() {
        return this.innerMatch() == null ? null : this.innerMatch().regexMatch();
    }

    public HeaderMatch withRegexMatch(String regexMatch) {
        if (this.innerMatch() == null) {
            this.innerMatch = new HeaderMatchMatch();
        }
        this.innerMatch().withRegexMatch(regexMatch);
        return this;
    }

    public void validate() {
        if (this.innerMatch() != null) {
            this.innerMatch().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("header", this.headerProperty);
        jsonWriter.writeJsonField("match", (JsonSerializable)this.innerMatch);
        return jsonWriter.writeEndObject();
    }

    public static HeaderMatch fromJson(JsonReader jsonReader) throws IOException {
        return (HeaderMatch)jsonReader.readObject(reader -> {
            HeaderMatch deserializedHeaderMatch = new HeaderMatch();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("header".equals(fieldName)) {
                    deserializedHeaderMatch.headerProperty = reader.getString();
                    continue;
                }
                if ("match".equals(fieldName)) {
                    deserializedHeaderMatch.innerMatch = HeaderMatchMatch.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHeaderMatch;
        });
    }
}

