/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class Header
implements JsonSerializable<Header> {
    private String key;
    private String value;

    public String key() {
        return this.key;
    }

    public Header withKey(String key) {
        this.key = key;
        return this;
    }

    public String value() {
        return this.value;
    }

    public Header withValue(String value) {
        this.value = value;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("key", this.key);
        jsonWriter.writeStringField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    public static Header fromJson(JsonReader jsonReader) throws IOException {
        return (Header)jsonReader.readObject(reader -> {
            Header deserializedHeader = new Header();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("key".equals(fieldName)) {
                    deserializedHeader.key = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedHeader.value = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHeader;
        });
    }
}

