/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.fluent.models.DotNetComponentInner;
import java.io.IOException;
import java.util.List;

public final class DotNetComponentsCollection
implements JsonSerializable<DotNetComponentsCollection> {
    private List<DotNetComponentInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(DotNetComponentsCollection.class);

    public List<DotNetComponentInner> value() {
        return this.value;
    }

    public DotNetComponentsCollection withValue(List<DotNetComponentInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model DotNetComponentsCollection"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DotNetComponentsCollection fromJson(JsonReader jsonReader) throws IOException {
        return (DotNetComponentsCollection)jsonReader.readObject(reader -> {
            DotNetComponentsCollection deserializedDotNetComponentsCollection = new DotNetComponentsCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedDotNetComponentsCollection.value = value = reader.readArray(reader1 -> DotNetComponentInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedDotNetComponentsCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDotNetComponentsCollection;
        });
    }
}

