/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.fluent.models.DotNetComponentInner;
import com.azure.resourcemanager.appcontainers.models.DotNetComponentConfigurationProperty;
import com.azure.resourcemanager.appcontainers.models.DotNetComponentProvisioningState;
import com.azure.resourcemanager.appcontainers.models.DotNetComponentServiceBind;
import com.azure.resourcemanager.appcontainers.models.DotNetComponentType;
import java.util.List;

public interface DotNetComponent {
    public String id();

    public String name();

    public String type();

    public SystemData systemData();

    public DotNetComponentType componentType();

    public DotNetComponentProvisioningState provisioningState();

    public List<DotNetComponentConfigurationProperty> configurations();

    public List<DotNetComponentServiceBind> serviceBinds();

    public String resourceGroupName();

    public DotNetComponentInner innerModel();

    public Update update();

    public DotNetComponent refresh();

    public DotNetComponent refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithServiceBinds {
            public Update withServiceBinds(List<DotNetComponentServiceBind> var1);
        }

        public static interface WithConfigurations {
            public Update withConfigurations(List<DotNetComponentConfigurationProperty> var1);
        }

        public static interface WithComponentType {
            public Update withComponentType(DotNetComponentType var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithComponentType,
    UpdateStages.WithConfigurations,
    UpdateStages.WithServiceBinds {
        public DotNetComponent apply();

        public DotNetComponent apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithServiceBinds {
            public WithCreate withServiceBinds(List<DotNetComponentServiceBind> var1);
        }

        public static interface WithConfigurations {
            public WithCreate withConfigurations(List<DotNetComponentConfigurationProperty> var1);
        }

        public static interface WithComponentType {
            public WithCreate withComponentType(DotNetComponentType var1);
        }

        public static interface WithCreate
        extends WithComponentType,
        WithConfigurations,
        WithServiceBinds {
            public DotNetComponent create();

            public DotNetComponent create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingManagedEnvironment(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

