/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.DiagnosticDataProviderMetadataPropertyBagItem;
import java.io.IOException;
import java.util.List;

public final class DiagnosticDataProviderMetadata
implements JsonSerializable<DiagnosticDataProviderMetadata> {
    private String providerName;
    private List<DiagnosticDataProviderMetadataPropertyBagItem> propertyBag;

    public String providerName() {
        return this.providerName;
    }

    public DiagnosticDataProviderMetadata withProviderName(String providerName) {
        this.providerName = providerName;
        return this;
    }

    public List<DiagnosticDataProviderMetadataPropertyBagItem> propertyBag() {
        return this.propertyBag;
    }

    public DiagnosticDataProviderMetadata withPropertyBag(List<DiagnosticDataProviderMetadataPropertyBagItem> propertyBag) {
        this.propertyBag = propertyBag;
        return this;
    }

    public void validate() {
        if (this.propertyBag() != null) {
            this.propertyBag().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("providerName", this.providerName);
        jsonWriter.writeArrayField("propertyBag", this.propertyBag, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DiagnosticDataProviderMetadata fromJson(JsonReader jsonReader) throws IOException {
        return (DiagnosticDataProviderMetadata)jsonReader.readObject(reader -> {
            DiagnosticDataProviderMetadata deserializedDiagnosticDataProviderMetadata = new DiagnosticDataProviderMetadata();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("providerName".equals(fieldName)) {
                    deserializedDiagnosticDataProviderMetadata.providerName = reader.getString();
                    continue;
                }
                if ("propertyBag".equals(fieldName)) {
                    List propertyBag;
                    deserializedDiagnosticDataProviderMetadata.propertyBag = propertyBag = reader.readArray(reader1 -> DiagnosticDataProviderMetadataPropertyBagItem.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDiagnosticDataProviderMetadata;
        });
    }
}

