/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.fluent.models.DaprSubscriptionInner;
import java.io.IOException;
import java.util.List;

public final class DaprSubscriptionsCollection
implements JsonSerializable<DaprSubscriptionsCollection> {
    private List<DaprSubscriptionInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(DaprSubscriptionsCollection.class);

    public List<DaprSubscriptionInner> value() {
        return this.value;
    }

    public DaprSubscriptionsCollection withValue(List<DaprSubscriptionInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model DaprSubscriptionsCollection"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DaprSubscriptionsCollection fromJson(JsonReader jsonReader) throws IOException {
        return (DaprSubscriptionsCollection)jsonReader.readObject(reader -> {
            DaprSubscriptionsCollection deserializedDaprSubscriptionsCollection = new DaprSubscriptionsCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedDaprSubscriptionsCollection.value = value = reader.readArray(reader1 -> DaprSubscriptionInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedDaprSubscriptionsCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDaprSubscriptionsCollection;
        });
    }
}

